/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.SHCEEMain;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.ColorComboBox;

public class EnumEditor
extends AbstractEditor {
    private static final long serialVersionUID = -7583780384335242111L;
    private int bits;
    private Integer defaultVal;
    private int defaultIndex;
    private ArrayList<Integer> itemIndex2enumValue;
    private HashMap<Integer, Integer> enumValue2itemIndex;
    private ColorComboBox input;

    public EnumEditor(Node root, Color baseColor, int arrayIndex) {
        super(root, baseColor, arrayIndex);
        this.format = "Enum value of " + this.bits + " bits";
        if (null != this.defaultVal) {
            this.format = this.format + " (default: " + this.defaultVal + ")";
        }
        this.addLabel(this.format);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 0));
        inputPanel.setBackground(this.getBackground());
        inputPanel.add(this.input);
        if (null != this.defaultVal) {
            JButton buttonDefault = new JButton("Default");
            buttonDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnumEditor.this.onButtonDefault();
                }
            });
            inputPanel.add(Box.createRigidArea(new Dimension(6, 6)));
            inputPanel.add(buttonDefault);
        }
        this.add(inputPanel);
        this.description = Util.getChildNodeValue(root, "Description");
        this.addLabel(this.description);
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumEditor.this.onChangeValue();
            }
        });
    }

    private void onButtonDefault() {
        this.input.setSelectedIndex(this.defaultIndex);
    }

    protected void onChangeValue() {
        if (this.id.equals("DeviceType")) {
            SHCEEMain.mySHCEEMain.valueEditor.updateBlockVisibility();
        }
        if (null != this.defaultVal && this.input.getSelectedIndex() != this.defaultIndex) {
            this.input.setBackground(Color.YELLOW);
        } else {
            this.input.setBackground(Color.WHITE);
        }
    }

    @Override
    public boolean dataIsValid() {
        return true;
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int enumValue = Util.getUIntFromByteArray(eeprom, offsetBit, this.bits);
        int index = 0;
        if (this.enumValue2itemIndex.containsKey(enumValue)) {
            index = this.enumValue2itemIndex.get(enumValue);
        }
        this.input.setSelectedIndex(index);
        return this.bits;
    }

    @Override
    public void setDefinitionParameter(Node n) {
        int v;
        String name;
        if (null == this.itemIndex2enumValue) {
            this.itemIndex2enumValue = new ArrayList();
            this.enumValue2itemIndex = new HashMap();
            this.input = new ColorComboBox();
        }
        if ((name = n.getNodeName()).equals("Bits")) {
            this.bits = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("Element")) {
            NodeList nl = n.getChildNodes();
            String v2 = "";
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n2 = nl.item(i);
                String name2 = n2.getNodeName();
                if (name2.equals("Value")) {
                    v2 = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (!name2.equals("Name")) continue;
                this.input.addItem(n2.getFirstChild().getNodeValue() + " (" + v2 + ")");
                this.itemIndex2enumValue.add(Integer.parseInt(v2));
                this.enumValue2itemIndex.put(Integer.parseInt(v2), this.input.getItemCount() - 1);
            }
        } else if (name.equals("DefaultVal") && this.enumValue2itemIndex.containsKey(v = Integer.parseInt(n.getFirstChild().getNodeValue()))) {
            this.defaultVal = v;
            this.defaultIndex = this.enumValue2itemIndex.get(this.defaultVal);
        }
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int value = this.itemIndex2enumValue.get(this.input.getSelectedIndex());
        Util.setUIntInByteArray(value, eeprom, offsetBit, this.bits);
        return this.bits;
    }

    @Override
    public String getValue(boolean humanReadable) {
        if (humanReadable) {
            return (String)this.input.getSelectedItem();
        }
        return "" + this.itemIndex2enumValue.get(this.input.getSelectedIndex());
    }

    public ArrayList<Integer> getValues() {
        return this.itemIndex2enumValue;
    }
}

