/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.LabelArea;
import shcee.Util;
import shcee.editors.Block;

public abstract class AbstractEditor
extends JPanel {
    private static final long serialVersionUID = -1309313960513732321L;
    public String id;
    public String description = null;
    public String format = null;
    protected TitledBorder border;
    private int arrayIndex;

    public AbstractEditor(Node root, Color baseColor, int arrayIndex) {
        this.arrayIndex = arrayIndex;
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String name = n.getNodeName();
            if (name.equals("ID")) {
                this.id = n.getFirstChild().getNodeValue();
                continue;
            }
            this.setDefinitionParameter(n);
        }
        if (null == this.id) {
            this.id = root.getNodeName();
        }
        String borderTitle = arrayIndex == -1 ? this.id : this.id + "[" + arrayIndex + "]";
        this.border = BorderFactory.createTitledBorder(borderTitle);
        this.border.setTitleFont(Block.getTitledBorderFont());
        this.setBorder(this.border);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractEditor.this.onResize();
            }
        };
        this.setBackground(Util.blendColor(baseColor, Color.white, 0.5));
        this.addComponentListener(resizeListener);
    }

    public void addLabel(String desc) {
        boolean isArray;
        boolean bl = isArray = this.arrayIndex != -1;
        if (!isArray) {
            LabelArea myLabel = new LabelArea(desc);
            this.add(myLabel);
        }
    }

    private void onResize() {
        this.invalidate();
    }

    public abstract void setDefinitionParameter(Node var1);

    public abstract int readFromEepromArray(byte[] var1, int var2);

    public abstract int writeToEepromArray(byte[] var1, int var2);

    public abstract boolean dataIsValid();

    public abstract String getValue(boolean var1);
}

