/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.io.File;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import shcee.DeviceTableModel;
import shcee.SHCEEMain;
import shcee.ValueEditorPanel;

public class DeviceSelectorTable
extends JTable {
    private static final long serialVersionUID = 3772504528864774739L;
    private DefaultTableModel model = new DeviceTableModel();
    private TableRowSorter<TableModel> sorter;

    public DeviceSelectorTable() {
        this.model.setColumnCount(3);
        this.model.setColumnIdentifiers(new String[]{"DeviceID", "Name", "DeviceType"});
        this.setModel(this.model);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                DeviceSelectorTable.this.onRowSelected();
            }
        });
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        TableColumn colDeviceID = this.getColumnModel().getColumn(0);
        colDeviceID.setMinWidth(60);
        colDeviceID.setMaxWidth(60);
        this.sorter = new TableRowSorter();
        this.setRowSorter(this.sorter);
        this.sorter.setModel(this.model);
        this.sorter.setComparator(0, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return Integer.parseInt(o1.toString()) - Integer.parseInt(o2.toString());
            }
        });
        ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.getColumnModel().getColumn(0).setCellRenderer(centerRenderer);
        this.updateTable();
        this.sorter.toggleSortOrder(0);
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
    }

    private void addRow(int deviceID, String name, String typeID) {
        Object[] rowData = new Object[]{deviceID, name, typeID};
        this.model.addRow(rowData);
    }

    public void updateTable() {
        this.model.setRowCount(0);
        File d = new File(".");
        if (d.isDirectory()) {
            File[] filesAndDirs = d.listFiles();
            for (int i = 0; i < filesAndDirs.length; ++i) {
                long length;
                if (!filesAndDirs[i].isFile() || !filesAndDirs[i].getName().toLowerCase().endsWith(".e2p") || (length = filesAndDirs[i].length()) != 512L && length != 1024L && length != 2048L && length != 4096L) continue;
                String name = filesAndDirs[i].getName();
                name = name.substring(0, name.length() - 4);
                this.addRow(0, name, "");
            }
        }
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.updateTableDataForRow(i);
        }
        this.sort();
    }

    public void sort() {
        this.sorter.sort();
    }

    protected void onRowSelected() {
        int row = this.getSelectedRow();
        if (row != -1) {
            SHCEEMain.mySHCEEMain.loadE2pFile((String)this.getValueAt(this.getSelectedRow(), 1) + ".e2p");
        }
    }

    public void updateTableDataForRow(int row) {
        String filename = (String)this.getValueAt(row, 1) + ".e2p";
        SHCEEMain.mySHCEEMain.loadE2pFile(filename);
        ValueEditorPanel ed = SHCEEMain.mySHCEEMain.valueEditor;
        String deviceID = ed.findValue("DeviceID", true);
        String deviceType = ed.findValue("DeviceType", true);
        this.setValueAt(deviceID, row, 0);
        this.setValueAt(deviceType, row, 2);
    }

    public void selectElement(String devicename) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 1)).equals(devicename)) continue;
            this.setRowSelectionInterval(i, i);
            return;
        }
    }
}

