/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import shcee.DeviceSelectorTable;
import shcee.SHCEEMain;
import shcee.Util;

public class DeviceSelectorPanel
extends JPanel {
    private static final long serialVersionUID = 2679223550063036996L;
    private DeviceSelectorTable deviceSelectorTable = new DeviceSelectorTable();

    public DeviceSelectorPanel() {
        JScrollPane scrollPane = new JScrollPane();
        JLabel headingLabel = new JLabel("Device List", 0);
        headingLabel.setFont(new Font(headingLabel.getFont().getName(), 1, 14));
        JPanel headingPanel = new JPanel(new FlowLayout(1, 6, 6));
        headingPanel.add(headingLabel);
        JButton buttonAddDevice = new JButton("Add Device");
        buttonAddDevice.setMnemonic('a');
        buttonAddDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSelectorPanel.this.onButtonAddDevice();
            }
        });
        JButton buttonDeleteDevice = new JButton("Delete Device");
        buttonDeleteDevice.setMnemonic('d');
        buttonDeleteDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSelectorPanel.this.onButtonDeleteDevice();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(buttonAddDevice);
        buttonPanel.add(buttonDeleteDevice);
        this.setLayout(new BorderLayout());
        this.add((Component)headingPanel, "North");
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonPanel, "South");
        scrollPane.getViewport().add(this.deviceSelectorTable);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
    }

    protected void onButtonDeleteDevice() {
        String device = (String)this.deviceSelectorTable.getValueAt(this.deviceSelectorTable.getSelectedRow(), 1);
        int res = JOptionPane.showConfirmDialog(SHCEEMain.mySHCEEMain, "Really delete device " + device + "?", "Please confirm", 0);
        if (res == 0) {
            new File(device + ".e2p").delete();
            this.deviceSelectorTable.updateTable();
            if (this.deviceSelectorTable.getRowCount() > 0) {
                this.deviceSelectorTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    protected void onButtonAddDevice() {
        String filename = JOptionPane.showInputDialog(SHCEEMain.mySHCEEMain, "Enter name of new device (e2p filename w/o extension)", "Enter name", -1);
        if (null != filename) {
            if (!(filename = filename.trim()).toLowerCase().endsWith(".e2p")) {
                filename = filename + ".e2p";
            }
            if (new File(filename).exists()) {
                JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "File " + filename + " already exists.", "Error", 0);
                return;
            }
            try {
                Util.createBinaryFile(filename, 1024);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "Could not create file " + filename + ".", "Error", 0);
                e.printStackTrace();
                return;
            }
            this.deviceSelectorTable.updateTable();
            this.deviceSelectorTable.selectElement(filename.substring(0, filename.length() - 4));
        }
    }

    public void updateCurrentRow() {
        this.deviceSelectorTable.updateTableDataForRow(this.deviceSelectorTable.getSelectedRow());
        this.deviceSelectorTable.sort();
    }
}

