/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import shcee.Util;
import shcee.editors.TextFieldLimit;

public class UIntTextArea
extends JTextArea {
    private static final long serialVersionUID = -2796855809983284807L;
    private boolean valid;
    private long minVal;
    private long maxVal;
    private Long defaultVal;

    public UIntTextArea(long minVal, long maxVal, Long defaultVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.defaultVal = defaultVal;
        int charLimit = (int)Math.log10(maxVal) + 1;
        if (minVal < 0L) {
            ++charLimit;
        }
        TextFieldLimit d = new TextFieldLimit(charLimit);
        this.setDocument(d);
        this.setText("" + minVal);
        d.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                UIntTextArea.this.checkInput();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UIntTextArea.this.checkInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UIntTextArea.this.checkInput();
            }
        });
        this.checkInput();
    }

    protected void checkInput() {
        this.valid = Util.isIntegerBetween(this.getText(), this.minVal, this.maxVal);
        if (!this.valid) {
            this.setBackground(Color.RED);
        } else if (null != this.defaultVal && !this.defaultVal.toString().equals(this.getText())) {
            this.setBackground(Color.YELLOW);
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    public boolean dataIsValid() {
        return this.valid;
    }
}

