/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.DefaultCaret;
import org.w3c.dom.Node;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.ByteArrayTextArea;

public class ByteArrayEditor
extends AbstractEditor {
    private static final long serialVersionUID = -4736742201423869251L;
    private int bytes;
    private String defaultVal;
    private ByteArrayTextArea input;

    public ByteArrayEditor(Node root, Color baseColor, int arrayIndex) {
        super(root, baseColor, arrayIndex);
        this.format = "ByteArray of " + this.bytes + " bytes (use HEX format as input)";
        if (null != this.defaultVal) {
            this.format = this.format + " (default: " + this.defaultVal + ")";
        }
        this.addLabel(this.format);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 0));
        inputPanel.setBackground(this.getBackground());
        this.input = new ByteArrayTextArea(this.bytes, this.defaultVal);
        inputPanel.add(this.input);
        if (null != this.defaultVal) {
            JButton buttonDefault = new JButton("Default");
            buttonDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ByteArrayEditor.this.onButtonDefault();
                }
            });
            inputPanel.add(Box.createRigidArea(new Dimension(6, 6)));
            inputPanel.add(buttonDefault);
        }
        JButton buttonMode = new JButton("HEX/Text");
        buttonMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ByteArrayEditor.this.onButtonMode();
            }
        });
        inputPanel.add(Box.createRigidArea(new Dimension(6, 6)));
        inputPanel.add(buttonMode);
        this.add(inputPanel);
        this.description = Util.getChildNodeValue(root, "Description");
        this.addLabel(this.description);
    }

    private void onButtonDefault() {
        this.input.setText(this.defaultVal);
    }

    private void onButtonMode() {
        this.input.toggleMode();
    }

    @Override
    public boolean dataIsValid() {
        return this.input.dataIsValid();
    }

    @Override
    public void setDefinitionParameter(Node n) {
        String name = n.getNodeName();
        if (name.equals("Bytes")) {
            this.bytes = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("DefaultVal")) {
            this.defaultVal = n.getFirstChild().getNodeValue();
        }
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        String s = "";
        for (int i = 0; i < this.bytes; ++i) {
            byte b = (byte)Util.getUIntFromByteArray(eeprom, offsetBit + i * 8, 8);
            s = s + Util.byteToHex(b);
        }
        DefaultCaret caret = (DefaultCaret)this.input.getCaret();
        caret.setUpdatePolicy(1);
        this.input.setMode(true);
        this.input.setText(s);
        caret.setUpdatePolicy(2);
        return this.bytes * 8;
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        byte[] buf = this.input.getBytes();
        for (int i = 0; i < this.bytes; ++i) {
            Util.setUIntInByteArray(buf[i], eeprom, offsetBit, 8);
            offsetBit += 8;
        }
        return this.bytes * 8;
    }

    @Override
    public String getValue(boolean humanReadable) {
        return this.input.getText();
    }
}

