/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Util {
    protected static final char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Node readXML(File XMLinput) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(XMLinput);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static void executeProg(String cmdLine) throws IOException {
        Runtime r = Runtime.getRuntime();
        r.exec(cmdLine);
    }

    static String conformsToSchema(String xmlFile, String xsdFile) {
        try {
            FileInputStream xmlFis = new FileInputStream(xmlFile);
            FileInputStream xsdFis = new FileInputStream(xsdFile);
            return Util.conformsToSchema(xmlFis, xsdFis);
        }
        catch (FileNotFoundException e) {
            return e.toString();
        }
    }

    static String conformsToSchema(InputStream xml, InputStream xsd) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(xsd));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            return null;
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        finally {
            try {
                if (ous != null) {
                    ous.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ous.toByteArray();
    }

    public static Node getChildNode(Node root, String childName) {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(childName)) continue;
            return nl.item(i);
        }
        System.err.println("Childnode " + childName + " not found!");
        return null;
    }

    public static String getChildNodeValue(Node root, String childName, boolean emptyStringOnMissingChild) {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(childName)) continue;
            Node textNode = nl.item(i).getFirstChild();
            if (textNode == null) {
                return "";
            }
            return textNode.getNodeValue();
        }
        if (emptyStringOnMissingChild) {
            return "";
        }
        System.err.println("Childnode " + childName + " not found!");
        return null;
    }

    public static String getChildNodeValue(Node root, String childName) {
        return Util.getChildNodeValue(root, childName, false);
    }

    public static boolean runsOnWindows() {
        return System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    public static void execute(String cmdLine) throws IOException {
        if (Util.runsOnWindows()) {
            Util.writeFile("flash_tmp.cmd", "@echo off\r\n" + cmdLine + "\r\npause\r\nexit\r\n");
            Runtime.getRuntime().exec("cmd /c start flash_tmp.cmd");
        } else {
            cmdLine = cmdLine.replaceAll(" {2,}", " ");
            String[] cmdArray = cmdLine.split(" ");
            Runtime.getRuntime().exec(cmdArray);
        }
    }

    public static Color blendColor(Color clOne, Color clTwo, double amount) {
        float fAmount = (float)amount;
        float fInverse = 1.0f - fAmount;
        float[] afOne = new float[3];
        clOne.getColorComponents(afOne);
        float[] afTwo = new float[3];
        clTwo.getColorComponents(afTwo);
        float[] afResult = new float[]{afOne[0] * fAmount + afTwo[0] * fInverse, afOne[1] * fAmount + afTwo[1] * fInverse, afOne[2] * fAmount + afTwo[2] * fInverse};
        return new Color(afResult[0], afResult[1], afResult[2]);
    }

    public static int getUIntFromByteArray(byte[] byteArray, int startBit, int lengthBits) {
        int res = 0;
        for (int i = 0; i < lengthBits; ++i) {
            int byteOffset = (startBit + i) / 8;
            int bitOffset = 7 - (startBit + i - byteOffset * 8);
            int dstBitOffset = lengthBits - 1 - i;
            int bit = byteArray[byteOffset] >> bitOffset & 1;
            res += bit << dstBitOffset;
        }
        return res;
    }

    public static int getIntFromByteArray(byte[] byteArray, int startBit, int lengthBits) {
        boolean positive;
        long x = Util.getUIntFromByteArray(byteArray, startBit, lengthBits);
        String bits = Long.toBinaryString(x);
        while (bits.length() < 32) {
            bits = "0" + bits;
        }
        boolean bl = positive = bits.charAt(32 - lengthBits) == '0';
        if (positive) {
            return (int)x;
        }
        x ^= 0xFFFFFFFFFFFFFFFFL;
        x &= (long)((1 << lengthBits) - 1);
        return (int)(-(++x));
    }

    public static void setUIntInByteArray(int value, byte[] byteArray, int startBit, int lengthBits) {
        for (int i = 0; i < lengthBits; ++i) {
            int dstByteOffset = (startBit + i) / 8;
            int dstBitOffset = 7 - (startBit + i - dstByteOffset * 8);
            int srcBitOffset = lengthBits - 1 - i;
            int bit = value >> srcBitOffset & 1;
            int bitMask = 1 << dstBitOffset;
            int bitMaskNeg = 255 - bitMask;
            byteArray[dstByteOffset] = (byte)(byteArray[dstByteOffset] & bitMaskNeg | bit << dstBitOffset);
        }
    }

    public static void setIntInByteArray(int value, byte[] byteArray, int startBit, int lengthBits) {
        int uint = (value >> 31 & 1) << lengthBits - 1 | value & (1 << lengthBits - 1) - 1;
        Util.setUIntInByteArray(uint, byteArray, startBit, lengthBits);
    }

    public static String byteToHex(byte b) {
        int i = (b + 256) % 256;
        return "" + hexArray[i >>> 4] + hexArray[i & 0xF];
    }

    public static String fillString(char fillChar, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, fillChar);
        return new String(chars);
    }

    public static void createBinaryFile(String filename, int bytes) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(new byte[bytes]);
        fos.close();
    }

    public static void writeFile(String filename, byte[] byteArray) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(byteArray);
        fos.close();
    }

    public static void writeFile(String filename, String text) throws IOException {
        FileWriter outFile = new FileWriter(filename);
        outFile.write(text);
        outFile.close();
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isIntegerBetween(String s, long minVal, long maxVal) {
        if (!Util.isInteger(s)) {
            return false;
        }
        int i = Integer.parseInt(s);
        return (long)i >= minVal && (long)i <= maxVal;
    }

    public static boolean isHexString(String text) {
        return text.length() % 2 == 0 && text.replaceAll("[0-9]|[a-f]|[A-F]", "").equals("");
    }

    public static byte hexToByte(Character cHigh, Character cLow) {
        return (byte)((Character.digit(cHigh.charValue(), 16) << 4) + Character.digit(cLow.charValue(), 16));
    }

    public static String arrayListToString(ArrayList<String> al, String delimiter) {
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String o : al) {
            if (first) {
                first = false;
            } else {
                out.append(delimiter);
            }
            out.append(o.toString());
        }
        return out.toString();
    }

    public static String calcAccessStr(String additionalOffsetPrefix, int offset, int bits, boolean isArray) {
        String res = additionalOffsetPrefix.equals("") ? "" + offset : "" + additionalOffsetPrefix + offset;
        if (isArray) {
            res = res + " + (uint16_t)index * " + bits;
        }
        return res;
    }
}

