/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import shcee.Util;
import shcee.editors.TextFieldLimit;

public class ByteArrayTextArea
extends JTextArea {
    private static final long serialVersionUID = -2796855809983284807L;
    private boolean valid;
    private int bytes;
    private String defaultVal;
    private boolean hexMode = true;
    private TextFieldLimit doc;

    public ByteArrayTextArea(int bytes, String defaultVal) {
        this.bytes = bytes;
        this.defaultVal = defaultVal;
        this.doc = new TextFieldLimit(bytes * 2);
        this.setDocument(this.doc);
        this.setText(Util.fillString('0', bytes * 2));
        this.doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ByteArrayTextArea.this.checkInput();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ByteArrayTextArea.this.checkInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ByteArrayTextArea.this.checkInput();
            }
        });
        this.setLineWrap(true);
        this.checkInput();
    }

    public String textToHex(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.bytes; ++i) {
            if (text.length() <= i) continue;
            sb.append(Util.byteToHex((byte)text.charAt(i)));
        }
        return sb.toString();
    }

    public void setMode(boolean hexMode) {
        this.hexMode = hexMode;
        if (hexMode) {
            this.doc.setLimit(this.bytes * 2);
            this.setText(this.textToHex(this.getText()));
        } else {
            String s = this.getText();
            byte[] buffer = new byte[this.bytes];
            for (int i = 0; i < this.bytes; ++i) {
                if (s.length() <= i * 2 + 1) continue;
                buffer[i] = Util.hexToByte(Character.valueOf(s.charAt(i * 2)), Character.valueOf(s.charAt(i * 2 + 1)));
            }
            this.setText(new String(buffer));
            this.doc.setLimit(this.bytes);
        }
    }

    public void toggleMode() {
        this.setMode(!this.hexMode);
    }

    protected void checkInput() {
        boolean bl = this.valid = this.hexMode && this.getText().length() == this.bytes * 2 && Util.isHexString(this.getText()) || !this.hexMode && this.getText().length() == this.bytes;
        if (!this.valid) {
            this.setBackground(Color.RED);
        } else if (null != this.defaultVal && !this.defaultVal.equals(this.getText())) {
            this.setBackground(Color.YELLOW);
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    public boolean dataIsValid() {
        return this.valid;
    }

    public byte[] getBytes() {
        byte[] res = new byte[this.bytes];
        String s = this.hexMode ? this.getText() : this.textToHex(this.getText());
        for (int i = 0; i < this.bytes; ++i) {
            res[i] = Util.hexToByte(Character.valueOf(s.charAt(i * 2)), Character.valueOf(s.charAt(i * 2 + 1)));
        }
        return res;
    }
}

