/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.FlashDialog;
import shcee.SHCEEMain;
import shcee.Util;
import shcee.ValueEditorBlockContainer;
import shcee.editors.Block;

public class ValueEditorPanel
extends JPanel {
    private static final long serialVersionUID = -2750864278619672384L;
    private static int[] blockColors = new int[]{0xFFD0D0, 0xD0FFD0, 0xD0D0FF, 0xFFFFA0, 0xA0FFFF, 0xFFA0FF};
    private int colorIndex = 0;
    private String filename = "";
    private JPanel blockContainer = new ValueEditorBlockContainer();
    private ArrayList<Block> blocks = new ArrayList();
    private JScrollPane scrollPane = new JScrollPane(this.blockContainer, 22, 31);
    private Node xmlRoot;
    private int length = 0;

    public ValueEditorPanel() {
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JLabel headingLabel = new JLabel("Value Editor", 0);
        headingLabel.setFont(new Font(headingLabel.getFont().getName(), 1, 14));
        JPanel headingPanel = new JPanel(new FlowLayout(1, 6, 6));
        headingPanel.add(headingLabel);
        JPanel colorCodesPanel = new JPanel();
        colorCodesPanel.setLayout(new BoxLayout(colorCodesPanel, 0));
        colorCodesPanel.add(new JLabel("Color codes:"));
        colorCodesPanel.add(Box.createRigidArea(new Dimension(6, 6)));
        colorCodesPanel.add(this.createColorCodeLabel(" invalid ", Color.RED));
        colorCodesPanel.add(Box.createRigidArea(new Dimension(6, 6)));
        colorCodesPanel.add(this.createColorCodeLabel(" default ", Color.WHITE));
        colorCodesPanel.add(Box.createRigidArea(new Dimension(6, 6)));
        colorCodesPanel.add(this.createColorCodeLabel(" differs from default ", Color.YELLOW));
        headingPanel.add(colorCodesPanel);
        JButton buttonSave = new JButton("Save");
        buttonSave.setMnemonic('s');
        buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueEditorPanel.this.onButtonSave();
            }
        });
        JButton buttonFlash = new JButton("Flash");
        buttonFlash.setMnemonic('f');
        buttonFlash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueEditorPanel.this.onButtonFlash();
            }
        });
        JButton buttonAbout = new JButton("About");
        buttonAbout.setMnemonic('a');
        buttonAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueEditorPanel.this.onButtonAbout();
            }
        });
        JPanel innerButtonPanel = new JPanel();
        innerButtonPanel.add(buttonSave);
        innerButtonPanel.add(buttonFlash);
        JPanel aboutButtonPanel = new JPanel();
        aboutButtonPanel.add(buttonAbout);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)innerButtonPanel, "Center");
        buttonPanel.add((Component)aboutButtonPanel, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)headingPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)buttonPanel, "South");
        this.initAccordingEepromLayout();
    }

    private JLabel createColorCodeLabel(String text, Color color) {
        JLabel label = new JLabel(text);
        label.setOpaque(true);
        label.setBackground(color);
        return label;
    }

    protected void onButtonAbout() {
        JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "<html><body><b>smarthomatic EEPROM Editor</b><br/>" + SHCEEMain.version + "<br/>http://www.smarthomatic.org<br/>Copyright (c) 2013..2016 Uwe Freese<br/>Licensed under GLP 3 or later.</body></html>", "About", 1);
    }

    protected void onButtonFlash() {
        String microcontrollerModel = null;
        for (Block b : this.blocks) {
            if (!b.isVisible() || b.microcontrollerModel == null) continue;
            microcontrollerModel = b.microcontrollerModel;
            break;
        }
        new FlashDialog(this.length, this.filename, microcontrollerModel);
    }

    protected void onButtonSave() {
        if (this.dataIsValid()) {
            this.writeToEepromFile();
            SHCEEMain.mySHCEEMain.deviceSelector.updateCurrentRow();
        } else {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "Some data is invalid. Fix it before saving.", "Invalid Data", 0);
        }
    }

    private void initAccordingEepromLayout() {
        String errMsg = Util.conformsToSchema("e2p_layout.xml", "e2p_metamodel.xsd");
        if (null != errMsg) {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "e2p_layout.xml does not conform to e2p_metamodel.xsd.\nError message:\n" + errMsg, "Error", 0);
            return;
        }
        try {
            this.xmlRoot = Util.readXML(new File("e2p_layout.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "e2p_layout.xml could not be loaded", "Error", 0);
            return;
        }
        this.xmlRoot = Util.getChildNode(this.xmlRoot, "E2P");
        NodeList nl = this.xmlRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals("Block")) continue;
            this.addBlock(n);
        }
    }

    private void addBlock(Node n) {
        Block b = new Block(new Color(blockColors[this.colorIndex]), n);
        this.colorIndex = (this.colorIndex + 1) % blockColors.length;
        this.blockContainer.add(b);
        this.blocks.add(b);
    }

    public void loadE2pFile(String filename) {
        final Rectangle rect = this.scrollPane.getVisibleRect();
        if (!this.filename.equals(filename)) {
            try {
                byte[] data = Util.readFileToByteArray(filename);
                this.readFromEepromArray(data);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "The file " + filename + " could not be read into a byte array.", "Cannot read file", 0);
            }
            this.filename = filename;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ValueEditorPanel.this.scrollPane.scrollRectToVisible(rect);
            }
        });
    }

    public void updateBlockVisibility() {
        for (Block b : this.blocks) {
            b.setVisible(false);
        }
        for (Block b : this.blocks) {
            boolean match = true;
            if (b.restrictionRefID != null) {
                String val = this.findValue(b.restrictionRefID, false);
                match = val.equals(b.restrictionValue);
            }
            b.setVisible(match);
        }
    }

    private void readFromEepromArray(byte[] eeprom) {
        int offset = 0;
        for (Block b : this.blocks) {
            b.setVisible(false);
        }
        for (Block b : this.blocks) {
            boolean match = true;
            if (b.restrictionRefID != null) {
                String val = this.findValue(b.restrictionRefID, false);
                match = val.equals(b.restrictionValue);
            }
            b.setVisible(match);
            if (!match) continue;
            int bitsProcessed = b.readFromEepromArray(eeprom, offset);
            offset += bitsProcessed;
        }
        this.length = offset;
    }

    private void writeToEepromFile() {
        byte[] eeprom = new byte[1024];
        int offset = 0;
        for (Block b : this.blocks) {
            if (!b.isVisible()) continue;
            int bitsProcessed = b.writeToEepromArray(eeprom, offset);
            offset += bitsProcessed;
        }
        if (offset <= 4096) {
            byte[] eeprom2 = new byte[512];
            System.arraycopy(eeprom, 0, eeprom2, 0, 512);
            eeprom = eeprom2;
        }
        try {
            Util.writeFile(this.filename, eeprom);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "Could not write file " + this.filename + ".", "Error", 0);
            e.printStackTrace();
        }
    }

    public String findValue(String id, boolean humanReadable) {
        for (Block b : this.blocks) {
            String val = b.findValue(id, humanReadable);
            if (null == val) continue;
            return val;
        }
        return null;
    }

    private boolean dataIsValid() {
        for (Block b : this.blocks) {
            if (!b.isVisible() || b.dataIsValid()) continue;
            return false;
        }
        return true;
    }

    public void enableEditorsForDeviceType(int deviceTypeID) {
        byte[] dummy = new byte[1024];
        int offset = 0;
        for (Block b : this.blocks) {
            boolean match = true;
            if (b.restrictionRefID != null && b.restrictionRefID.equals("DeviceType")) {
                match = b.restrictionValue.equals("" + deviceTypeID);
            }
            b.setVisible(match);
            if (!match) continue;
            int bitsProcessed = b.readFromEepromArray(dummy, offset);
            offset += bitsProcessed;
        }
    }
}

