/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.w3c.dom.Node;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.BoolArea;

public class BoolEditor
extends AbstractEditor {
    private static final long serialVersionUID = -7593115068369714873L;
    private int bits = 8;
    private Boolean defaultVal;
    private BoolArea input;

    public BoolEditor(Node root, Color baseColor, int arrayIndex) {
        super(root, baseColor, arrayIndex);
        this.format = "Boolean of 8 bits";
        if (null != this.defaultVal) {
            this.format = this.format + " (default: " + this.defaultVal + ")";
        }
        this.addLabel(this.format);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BorderLayout());
        inputPanel.setBackground(this.getBackground());
        this.input = new BoolArea(this.defaultVal);
        inputPanel.add((Component)this.input, "West");
        if (null != this.defaultVal) {
            JButton buttonDefault = new JButton("Default");
            buttonDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BoolEditor.this.onButtonDefault();
                }
            });
            Component glue = Box.createRigidArea(new Dimension(6, 6));
            glue.setPreferredSize(new Dimension(1000, 6));
            inputPanel.add(glue, "Center");
            inputPanel.add((Component)buttonDefault, "East");
        }
        this.add(inputPanel);
        this.description = Util.getChildNodeValue(root, "Description");
        this.addLabel(this.description);
    }

    private void onButtonDefault() {
        this.input.setSelected(this.defaultVal);
    }

    @Override
    public boolean dataIsValid() {
        return this.input.dataIsValid();
    }

    @Override
    public void setDefinitionParameter(Node n) {
        String name = n.getNodeName();
        if (name.equals("DefaultVal")) {
            this.defaultVal = n.getFirstChild().getNodeValue().equals("true");
        }
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int data = Util.getIntFromByteArray(eeprom, offsetBit, this.bits);
        this.input.setSelected(data != 0);
        return 8;
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int value = this.input.isSelected() ? 1 : 0;
        Util.setIntInByteArray(value, eeprom, offsetBit, this.bits);
        return 8;
    }

    @Override
    public String getValue(boolean humanReadable) {
        String s = this.input.getText();
        if (Util.isInteger(s)) {
            return "" + Integer.parseInt(s);
        }
        return "0";
    }
}

