/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.xml.transform.TransformerException;
import shcee.DeviceSelectorPanel;
import shcee.SourceCodeGeneratorE2P;
import shcee.SourceCodeGeneratorPacket;
import shcee.ValueEditorPanel;

public class SHCEEMain
extends JFrame {
    private static final long serialVersionUID = 1760274466931877539L;
    public static SHCEEMain mySHCEEMain = null;
    public static final String EEPROM_METAMODEL_XSD = "e2p_metamodel.xsd";
    public static final String EEPROM_LAYOUT_XML = "e2p_layout.xml";
    public static final String PACKET_METAMODEL_XSD = "packet_metamodel.xsd";
    public static final String PACKET_CATALOG_XML = "packet_layout.xml";
    private static String CFG_FILENAME = "shc_e2p_editor.cfg";
    public static int propWidth = 900;
    public static int propHeight = 600;
    public static int propDividerLocation = 400;
    public static String propFlashCmd = "";
    public static String version;
    private int oldWidth;
    public ValueEditorPanel valueEditor;
    public DeviceSelectorPanel deviceSelector;
    private JSplitPane jSplitPane;

    public SHCEEMain() {
        mySHCEEMain = this;
        this.loadProperties();
        this.readVersion();
        this.initializeMainFrame();
        this.valueEditor = new ValueEditorPanel();
        this.deviceSelector = new DeviceSelectorPanel();
        this.jSplitPane = new JSplitPane(1);
        this.jSplitPane.add(this.deviceSelector);
        this.jSplitPane.add(this.valueEditor);
        this.add(this.jSplitPane);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SHCEEMain.this.onResize();
            }
        };
        this.addComponentListener(resizeListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SHCEEMain.this.saveProperties();
            }
        });
        this.jSplitPane.setDividerLocation(propDividerLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(CFG_FILENAME);
            prop.load(input);
            propFlashCmd = prop.getProperty("flash_cmd");
            propWidth = Integer.parseInt(prop.getProperty("width", "" + propWidth));
            propHeight = Integer.parseInt(prop.getProperty("height", "" + propHeight));
            propDividerLocation = Integer.parseInt(prop.getProperty("divider_location", "" + propDividerLocation));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties() {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(CFG_FILENAME);
            prop.setProperty("flash_cmd", propFlashCmd);
            prop.setProperty("width", "" + this.getWidth());
            prop.setProperty("height", "" + this.getHeight());
            prop.setProperty("divider_location", "" + this.jSplitPane.getDividerLocation());
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void readVersion() {
        try {
            Properties p = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.smarthomatic/shcee/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version == null) {
            version = "(unofficial developer version)";
        }
    }

    private void onResize() {
        this.jSplitPane.setDividerLocation((int)((long)this.jSplitPane.getDividerLocation() * (long)this.getWidth() / (long)this.oldWidth));
        this.oldWidth = this.getWidth();
    }

    private void initializeMainFrame() {
        this.setName("SHCEE");
        this.setDefaultCloseOperation(2);
        this.setTitle("smarthomatic EEPROM Editor");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(propWidth, propHeight);
        this.setLocation((screenSize.width - propWidth) / 2, (screenSize.height - propHeight) / 2);
        this.oldWidth = propWidth;
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("/gen")) {
            try {
                new SourceCodeGeneratorE2P();
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                new SourceCodeGeneratorPacket();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            new SHCEEMain();
            mySHCEEMain.setVisible(true);
        }
    }

    public void loadE2pFile(String filename) {
        this.valueEditor.loadE2pFile(filename);
    }
}

