/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import shcee.SHCEEMain;
import shcee.Util;

public class FlashDialog
extends JDialog {
    private static final long serialVersionUID = -5437332123602239488L;
    private static String DEFAULT_CMD_WINDOWS = "avrdude.exe -p #DEVICE# -U eeprom:w:#FILENAME#:r";
    private static String DEFAULT_CMD_LINUX = "xterm -hold -e avrdude -p #DEVICE# -U eeprom:w:#FILENAME#:r";
    private JTextField textField;
    private int e2pLength;
    private String e2pFilename;
    private String microcontrollerModel;

    public FlashDialog(int e2pLength, String e2pFilename, String microcontrollerModel) {
        this.e2pLength = e2pLength;
        this.e2pFilename = e2pFilename;
        this.microcontrollerModel = microcontrollerModel;
        this.setTitle("Flash e2p file to device");
        this.addComponents();
        this.loadProperties();
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.textField.requestFocusInWindow();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FlashDialog.this.saveProperties();
            }
        });
        this.setVisible(true);
    }

    private void addComponents() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel l1 = new JLabel("Enter command for flashing e2p file");
        l1.setFont(new Font(l1.getFont().getName(), 1, l1.getFont().getSize()));
        l1.setAlignmentX(0.0f);
        panel.add(l1);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        panel.add(new JLabel("#DEVICE# will be replaced by the microcontroller model defined in the e2p layout or (if not defined) m328p or m168p according to e2p size"));
        panel.add(new JLabel("#FILENAME# will be replaced by the e2p filename"));
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        panel.add(new JLabel("Default is: " + (Util.runsOnWindows() ? DEFAULT_CMD_WINDOWS : DEFAULT_CMD_LINUX)));
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.textField = new JTextField(Util.runsOnWindows() ? DEFAULT_CMD_WINDOWS : DEFAULT_CMD_LINUX);
        this.textField.setAlignmentX(0.0f);
        panel.add(this.textField);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JButton buttonFlash = new JButton("Flash");
        JButton buttonRestoreDefaults = new JButton("Restore Defaults");
        JButton buttonCancel = new JButton("Cancel");
        buttonFlash.setMnemonic('f');
        buttonFlash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashDialog.this.onButtonFlash();
            }
        });
        buttonRestoreDefaults.setMnemonic('d');
        buttonRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashDialog.this.onButtonRestoreDefaults();
            }
        });
        buttonCancel.setMnemonic('c');
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashDialog.this.onButtonCancel();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(buttonFlash);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(buttonRestoreDefaults);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(buttonCancel);
        buttonPane.setAlignmentX(0.0f);
        panel.add(buttonPane);
        this.add(panel);
        this.getRootPane().setDefaultButton(buttonFlash);
    }

    private void onButtonFlash() {
        String cmdLineS = this.textField.getText();
        cmdLineS = this.microcontrollerModel != null ? cmdLineS.replace("#DEVICE#", this.microcontrollerModel) : (this.e2pLength > 4096 ? cmdLineS.replace("#DEVICE#", "m328p") : cmdLineS.replace("#DEVICE#", "m168p"));
        cmdLineS = cmdLineS.replace("#FILENAME#", "\"" + this.e2pFilename + "\"");
        try {
            Util.execute(cmdLineS);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "Could not execute program.", "Error", 0);
            e.printStackTrace();
        }
    }

    private void onButtonRestoreDefaults() {
        this.textField.setText(Util.runsOnWindows() ? DEFAULT_CMD_WINDOWS : DEFAULT_CMD_LINUX);
    }

    private void onButtonCancel() {
        this.saveProperties();
        this.setVisible(false);
    }

    private void loadProperties() {
        if (!SHCEEMain.propFlashCmd.equals("")) {
            this.textField.setText(SHCEEMain.propFlashCmd);
        }
    }

    private void saveProperties() {
        SHCEEMain.propFlashCmd = this.textField.getText();
    }
}

