/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.DefaultCaret;
import org.w3c.dom.Node;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.UIntTextArea;

public class IntEditor
extends AbstractEditor {
    private static final long serialVersionUID = -7593115068369714873L;
    private long minVal;
    private long maxVal;
    private Long defaultVal;
    private int bits;
    private UIntTextArea input;

    public IntEditor(Node root, Color baseColor, int arrayIndex) {
        super(root, baseColor, arrayIndex);
        this.format = "Int of " + this.bits + " bits in the range " + this.minVal + ".." + this.maxVal;
        if (null != this.defaultVal) {
            this.format = this.format + " (default: " + this.defaultVal + ")";
        }
        this.addLabel(this.format);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 0));
        inputPanel.setBackground(this.getBackground());
        this.input = new UIntTextArea(this.minVal, this.maxVal, this.defaultVal);
        inputPanel.add(this.input);
        if (null != this.defaultVal) {
            JButton buttonDefault = new JButton("Default");
            buttonDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IntEditor.this.onButtonDefault();
                }
            });
            inputPanel.add(Box.createRigidArea(new Dimension(6, 6)));
            inputPanel.add(buttonDefault);
        }
        this.add(inputPanel);
        this.description = Util.getChildNodeValue(root, "Description");
        this.addLabel(this.description);
    }

    private void onButtonDefault() {
        this.input.setText("" + this.defaultVal);
    }

    @Override
    public boolean dataIsValid() {
        return this.input.dataIsValid();
    }

    @Override
    public void setDefinitionParameter(Node n) {
        String name = n.getNodeName();
        if (name.equals("MinVal")) {
            this.minVal = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("MaxVal")) {
            this.maxVal = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("DefaultVal")) {
            this.defaultVal = new Long(Integer.parseInt(n.getFirstChild().getNodeValue()));
        } else if (name.equals("Bits")) {
            this.bits = Integer.parseInt(n.getFirstChild().getNodeValue());
        }
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int data = Util.getIntFromByteArray(eeprom, offsetBit, this.bits);
        DefaultCaret caret = (DefaultCaret)this.input.getCaret();
        caret.setUpdatePolicy(1);
        this.input.setText("" + data);
        caret.setUpdatePolicy(2);
        return this.bits;
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int value = Integer.parseInt(this.input.getText());
        Util.setIntInByteArray(value, eeprom, offsetBit, this.bits);
        return this.bits;
    }

    @Override
    public String getValue(boolean humanReadable) {
        String s = this.input.getText();
        if (Util.isInteger(s)) {
            return "" + Integer.parseInt(s);
        }
        return "0";
    }
}

