/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import shcee.Util;
import shcee.editors.TextFieldLimit;

public class ByteArrayTextArea
extends JTextArea {
    private static final long serialVersionUID = -2796855809983284807L;
    private boolean valid;
    private int bytes;
    private String defaultVal;

    public ByteArrayTextArea(int bytes, String defaultVal) {
        this.bytes = bytes;
        this.defaultVal = defaultVal;
        TextFieldLimit d = new TextFieldLimit(bytes * 2);
        this.setDocument(d);
        this.setText(Util.fillString('0', bytes * 2));
        d.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ByteArrayTextArea.this.checkInput();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ByteArrayTextArea.this.checkInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ByteArrayTextArea.this.checkInput();
            }
        });
        this.setLineWrap(true);
        this.checkInput();
    }

    protected void checkInput() {
        boolean bl = this.valid = this.getText().length() == this.bytes * 2 && Util.isHexString(this.getText());
        if (!this.valid) {
            this.setBackground(Color.RED);
        } else if (null != this.defaultVal && !this.defaultVal.equals(this.getText())) {
            this.setBackground(Color.YELLOW);
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    public boolean dataIsValid() {
        return this.valid;
    }
}

