/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.LabelArea;
import shcee.editors.AbstractEditor;
import shcee.editors.BoolEditor;
import shcee.editors.ByteArrayEditor;
import shcee.editors.EnumEditor;
import shcee.editors.IntEditor;
import shcee.editors.UIntEditor;

public class ArrayEditor
extends AbstractEditor {
    private static final long serialVersionUID = -7593115068369714873L;
    private ArrayList<AbstractEditor> editors = new ArrayList();
    private int length;

    public ArrayEditor(Node root, Color baseColor, int arrayIndex) {
        super(root, baseColor, arrayIndex);
        NodeList nl = root.getChildNodes();
        Node elementNode = nl.item(3);
        for (int i = 0; i < this.length; ++i) {
            if (elementNode.getNodeName().equals("UIntValue")) {
                this.addElem(new UIntEditor(elementNode, this.getBackground(), i));
                continue;
            }
            if (elementNode.getNodeName().equals("IntValue")) {
                this.addElem(new IntEditor(elementNode, this.getBackground(), i));
                continue;
            }
            if (elementNode.getNodeName().equals("BoolValue")) {
                this.addElem(new BoolEditor(elementNode, this.getBackground(), i));
                continue;
            }
            if (elementNode.getNodeName().equals("EnumValue")) {
                this.addElem(new EnumEditor(elementNode, this.getBackground(), i));
                continue;
            }
            if (!elementNode.getNodeName().equals("ByteArray")) continue;
            this.addElem(new ByteArrayEditor(elementNode, this.getBackground(), i));
        }
        if (this.length > 0) {
            this.format = "Array of " + this.length + " elements of " + this.editors.get((int)0).format;
            LabelArea lengthLabel = new LabelArea(this.format);
            this.add((Component)lengthLabel, 0);
            this.description = this.editors.get((int)0).description;
            LabelArea descriptionLabel = new LabelArea(this.description);
            this.add((Component)descriptionLabel, 1);
            TitledBorder border = (TitledBorder)this.getBorder();
            border.setTitle(this.editors.get((int)0).id + " (Array)");
        }
    }

    private void addElem(AbstractEditor c) {
        this.add(c);
        this.editors.add(c);
    }

    @Override
    public boolean dataIsValid() {
        for (int i = 0; i < this.editors.size(); ++i) {
            if (this.editors.get(i).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDefinitionParameter(Node n) {
        if (n.getNodeName().equals("Length")) {
            this.length = Integer.parseInt(n.getFirstChild().getNodeValue());
        }
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int bits = 0;
        for (int i = 0; i < this.editors.size(); ++i) {
            bits += this.editors.get(i).readFromEepromArray(eeprom, offsetBit + bits);
        }
        return bits;
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int bits = 0;
        for (int i = 0; i < this.editors.size(); ++i) {
            bits += this.editors.get(i).writeToEepromArray(eeprom, offsetBit + bits);
        }
        return bits;
    }

    @Override
    public String getValue(boolean humanReadable) {
        return "ARRAY";
    }
}

