/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import javax.swing.text.DefaultCaret;
import org.w3c.dom.Node;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.UIntTextArea;

public class IntEditor
extends AbstractEditor {
    private static final long serialVersionUID = -7593115068369714873L;
    private long minVal;
    private long maxVal;
    private int bits;
    private UIntTextArea input;

    public IntEditor(Node root, Color baseColor, int arrayIndex) {
        super(root, baseColor, arrayIndex);
        this.format = "Int of " + this.bits + " bits in the range " + this.minVal + ".." + this.maxVal;
        this.addLabel(this.format);
        this.input = new UIntTextArea(this.minVal, this.maxVal);
        this.add(this.input);
        this.description = Util.getChildNodeValue(root, "Description");
        this.addLabel(this.description);
    }

    @Override
    public boolean dataIsValid() {
        return this.input.dataIsValid();
    }

    @Override
    public void setDefinitionParameter(Node n) {
        String name = n.getNodeName();
        if (name.equals("MinVal")) {
            this.minVal = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("MaxVal")) {
            this.maxVal = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("Bits")) {
            this.bits = Integer.parseInt(n.getFirstChild().getNodeValue());
        }
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int data = Util.getIntFromByteArray(eeprom, offsetBit, this.bits);
        DefaultCaret caret = (DefaultCaret)this.input.getCaret();
        caret.setUpdatePolicy(1);
        this.input.setText("" + data);
        caret.setUpdatePolicy(2);
        return this.bits;
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int value = Integer.parseInt(this.input.getText());
        Util.setIntInByteArray(value, eeprom, offsetBit, this.bits);
        return this.bits;
    }

    @Override
    public String getValue(boolean humanReadable) {
        String s = this.input.getText();
        if (Util.isInteger(s)) {
            return "" + Integer.parseInt(s);
        }
        return "0";
    }
}

