/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import shcee.Util;
import shcee.editors.TextFieldLimit;

public class UIntTextArea
extends JTextArea {
    private static final long serialVersionUID = -2796855809983284807L;
    private boolean valid;
    private long minVal;
    private long maxVal;

    public UIntTextArea(long minVal, long maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
        int charLimit = (int)Math.log10(maxVal) + 1;
        if (minVal < 0L) {
            ++charLimit;
        }
        TextFieldLimit d = new TextFieldLimit(charLimit);
        this.setDocument(d);
        this.setText("" + minVal);
        d.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                UIntTextArea.this.checkInput();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UIntTextArea.this.checkInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UIntTextArea.this.checkInput();
            }
        });
        this.checkInput();
    }

    protected void checkInput() {
        this.valid = Util.isIntegerBetween(this.getText(), this.minVal, this.maxVal);
        if (this.valid) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(Color.RED);
        }
    }

    public boolean dataIsValid() {
        return this.valid;
    }
}

