/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.SHCEEMain;
import shcee.SourceCodeGeneratorPacket;
import shcee.Util;

public class SourceCodeGeneratorE2P {
    private static String newline = System.getProperty("line.separator");

    public SourceCodeGeneratorE2P() throws TransformerException, IOException {
        Node xmlRoot;
        String errMsg = Util.conformsToSchema("e2p_layout.xml", "e2p_metamodel.xsd");
        if (null != errMsg) {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "e2p_layout.xml does not conform to e2p_metamodel.xsd.\nError message:\n" + errMsg, "Error", 0);
            return;
        }
        try {
            xmlRoot = Util.readXML(new File("e2p_layout.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "e2p_layout.xml could not be loaded", "Error", 0);
            return;
        }
        xmlRoot = Util.getChildNode(xmlRoot, "E2P");
        int offset = 0;
        offset += this.generateBlockHeaderFile(xmlRoot, "Hardware", offset);
        offset += this.generateBlockHeaderFile(xmlRoot, "Generic", offset);
        NodeList blocks = XPathAPI.selectNodeList(xmlRoot, "Block");
        for (int b = 0; b < blocks.getLength(); ++b) {
            Node block = blocks.item(b);
            String blockName = Util.getChildNodeValue(block, "Name");
            if (blockName.equals("Hardware") || blockName.equals("Generic")) continue;
            Node restrictionValueNode = XPathAPI.selectSingleNode(block, "Restriction[RefID='DeviceType']");
            String deviceTypeID = Util.getChildNodeValue(restrictionValueNode, "Value");
            String deviceTypeName = this.deviceTypeNameOfDeviceTypeID(xmlRoot, Integer.parseInt(deviceTypeID));
            this.generateBlockHeaderFile(xmlRoot, deviceTypeName, offset);
        }
    }

    private String deviceTypeNameOfDeviceTypeID(Node xmlRoot, int devTypeID) throws TransformerException {
        Node def = XPathAPI.selectSingleNode(xmlRoot, "Block/EnumValue[ID='DeviceType']/Element[Value=" + devTypeID + "]");
        return Util.getChildNodeValue(def, "Name");
    }

    private int generateBlockHeaderFile(Node xmlRoot, String blockName, int offset) throws IOException, TransformerException {
        PrintWriter out = new PrintWriter(new FileWriter("../../firmware/src_common/e2p_" + blockName.toLowerCase() + ".h"));
        out.println(SourceCodeGeneratorPacket.genCopyrightNotice());
        out.println("#ifndef _E2P_" + blockName.toUpperCase() + "_H");
        out.println("#define _E2P_" + blockName.toUpperCase() + "_H");
        out.println("");
        Node hwConfigBlock = XPathAPI.selectSingleNode(xmlRoot, "Block[Name='" + blockName + "']");
        StringBuilder fieldDefs = new StringBuilder();
        int length = this.generateFieldDefs(hwConfigBlock, offset, "e2p_" + blockName.toLowerCase(), fieldDefs);
        String h = "// E2P Block \"" + blockName + "\"";
        out.println(h);
        out.println("// " + String.format("%-" + (h.length() - 3) + "s", "").replace(' ', '='));
        out.println("// Start offset (bit): " + offset);
        out.println("// Overall block length: " + length + " bits");
        out.println("");
        out.println(fieldDefs.toString());
        out.println("#endif /* _E2P_" + blockName.toUpperCase() + "_H */");
        out.close();
        return length;
    }

    private int generateFieldDefs(Node blockNode, int startOffset, String functionPrefix, StringBuilder sb) throws TransformerException {
        int offset = startOffset;
        NodeList elements = blockNode.getChildNodes();
        for (int e = 0; e < elements.getLength(); ++e) {
            String minVal;
            String ID;
            Node element = elements.item(e);
            String description = Util.getChildNodeValue(element, "Description", true);
            if (element.getNodeName().equals("EnumValue")) {
                String ID1 = Util.getChildNodeValue(element, "ID");
                int bits = Integer.parseInt(Util.getChildNodeValue(element, "Bits"));
                String ID2 = ID1.toUpperCase();
                int cTypeBits = this.calcCTypeBits(bits);
                sb.append("// " + ID1 + " (EnumValue)" + newline);
                if (!description.equals("")) {
                    sb.append("// Description: " + description + newline);
                }
                sb.append(newline);
                NodeList enumElements = XPathAPI.selectNodeList(element, "Element");
                sb.append("typedef enum {" + newline);
                for (int ee = 0; ee < enumElements.getLength(); ++ee) {
                    Node enumElement = enumElements.item(ee);
                    String value = Util.getChildNodeValue(enumElement, "Value");
                    String name = ID2 + "_" + Util.getChildNodeValue(enumElement, "Name").toUpperCase().replace(' ', '_');
                    String suffix = ee == enumElements.getLength() - 1 ? "" : ",";
                    sb.append("  " + name + " = " + value + suffix + newline);
                }
                sb.append("} " + ID1 + "Enum;" + newline);
                sb.append(newline);
                sb.append("// Set " + ID1 + " (EnumValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits " + bits + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID1.toLowerCase() + "(" + ID1 + "Enum val)" + newline);
                sb.append("{" + newline);
                sb.append("  eeprom_write_UIntValue(" + offset / 8 + ", " + offset % 8 + ", " + bits + ", val);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                int maxVal = (1 << cTypeBits) - 1;
                sb.append("// Get " + ID1 + " (EnumValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits " + bits + newline);
                sb.append("static inline " + ID1 + "Enum " + functionPrefix + "_get_" + ID1.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return eeprom_read_UIntValue" + cTypeBits + "(" + offset / 8 + ", " + offset % 8 + ", 8, 0, " + maxVal + ");" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += 8;
                continue;
            }
            if (element.getNodeName().equals("UIntValue")) {
                ID = Util.getChildNodeValue(element, "ID");
                int bits = Integer.parseInt(Util.getChildNodeValue(element, "Bits"));
                minVal = Util.getChildNodeValue(element, "MinVal");
                String maxVal = Util.getChildNodeValue(element, "MaxVal");
                int cTypeBits = this.calcCTypeBits(bits);
                sb.append("// " + ID + " (UIntValue)" + newline);
                if (!description.equals("")) {
                    sb.append("// Description: " + description + newline);
                }
                sb.append(newline);
                sb.append("// Set " + ID + " (UIntValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(uint" + cTypeBits + "_t val)" + newline);
                sb.append("{" + newline);
                sb.append("  eeprom_write_UIntValue(" + offset / 8 + ", " + offset % 8 + ", " + bits + ", val);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                sb.append("// Get " + ID + " (UIntValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline uint" + cTypeBits + "_t " + functionPrefix + "_get_" + ID.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return eeprom_read_UIntValue" + cTypeBits + "(" + offset / 8 + ", " + offset % 8 + ", " + bits + ", " + minVal + ", " + maxVal + ");" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += bits;
                continue;
            }
            if (element.getNodeName().equals("IntValue")) {
                ID = Util.getChildNodeValue(element, "ID");
                int bits = Integer.parseInt(Util.getChildNodeValue(element, "Bits"));
                minVal = Util.getChildNodeValue(element, "MinVal");
                String maxVal = Util.getChildNodeValue(element, "MaxVal");
                int cTypeBits = this.calcCTypeBits(bits);
                sb.append("// " + ID + " (IntValue)" + newline);
                if (!description.equals("")) {
                    sb.append("// Description: " + description + newline);
                }
                sb.append(newline);
                sb.append("// Set " + ID + " (IntValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(int" + cTypeBits + "_t val)" + newline);
                sb.append("{" + newline);
                sb.append("  eeprom_write_IntValue(" + offset / 8 + ", " + offset % 8 + ", " + bits + ", val);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                sb.append("// Get " + ID + " (IntValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline int" + cTypeBits + "_t " + functionPrefix + "_get_" + ID.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return eeprom_read_IntValue32(" + offset / 8 + ", " + offset % 8 + ", " + bits + ", " + minVal + ", " + maxVal + ");" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += bits;
                continue;
            }
            if (element.getNodeName().equals("ByteArray")) {
                ID = Util.getChildNodeValue(element, "ID");
                sb.append("// " + ID + " (ByteArray)" + newline);
                if (!description.equals("")) {
                    sb.append("// Description: " + description + newline);
                }
                sb.append(newline);
                ID = ID.toUpperCase();
                String bytes = Util.getChildNodeValue(element, "Bytes");
                sb.append("#define EEPROM_" + ID + "_BYTE " + offset / 8 + newline);
                sb.append("#define EEPROM_" + ID + "_BIT " + offset % 8 + newline);
                sb.append("#define EEPROM_" + ID + "_LENGTH_BYTES " + bytes + newline);
                sb.append(newline);
                offset += Integer.parseInt(bytes) * 8;
                continue;
            }
            if (element.getNodeName().equals("BoolValue")) {
                ID = Util.getChildNodeValue(element, "ID");
                sb.append("// " + ID + " (BoolValue)" + newline);
                if (!description.equals("")) {
                    sb.append("// Description: " + description + newline);
                }
                sb.append(newline);
                sb.append("// Set " + ID + " (BoolValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits 1" + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(bool val)" + newline);
                sb.append("{" + newline);
                sb.append("  eeprom_write_UIntValue(" + offset / 8 + ", " + offset % 8 + ", 1, val ? 1 : 0, bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                sb.append("// Get " + ID + " (BoolValue)" + newline);
                sb.append("// Byte offset: " + offset / 8 + ", bit offset: " + offset % 8 + ", length bits 1" + newline);
                sb.append("static inline bool " + functionPrefix + "_get_" + ID.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return eeprom_read_UIntValue8(" + offset / 8 + ", " + offset % 8 + ", 1, 0, 1, bufx) == 1;" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                ++offset;
                continue;
            }
            if (!element.getNodeName().equals("Reserved")) continue;
            String bits = Util.getChildNodeValue(element, "Bits");
            sb.append("// Reserved area with " + bits + " bits" + newline);
            sb.append(newline);
            offset += Integer.parseInt(bits);
        }
        return offset - startOffset;
    }

    private int calcCTypeBits(int bits) {
        int cTypeBits = ((bits - 1) / 8 + 1) * 8;
        if (cTypeBits == 24) {
            cTypeBits = 32;
        }
        return cTypeBits;
    }
}

