/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import javax.swing.text.DefaultCaret;
import org.w3c.dom.Node;
import shcee.LabelArea;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.ByteArrayTextArea;

public class ByteArrayEditor
extends AbstractEditor {
    private static final long serialVersionUID = -4736742201423869251L;
    private int bytes;
    private ByteArrayTextArea input;

    public ByteArrayEditor(Node root) {
        super(root);
        LabelArea formatLabel = new LabelArea("ByteArray of " + this.bytes + " bytes (use HEX format as input)");
        this.add(formatLabel);
        this.input = new ByteArrayTextArea(this.bytes);
        this.add(this.input);
        String blockDescription = Util.getChildNodeValue(root, "Description");
        LabelArea descriptionLabel = new LabelArea(blockDescription);
        this.add(descriptionLabel);
    }

    @Override
    public boolean dataIsValid() {
        return this.input.dataIsValid();
    }

    @Override
    public void setDefinitionParameter(Node n) {
        String name = n.getNodeName();
        if (name.equals("Bytes")) {
            this.bytes = Integer.parseInt(n.getFirstChild().getNodeValue());
        }
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        String s = "";
        for (int i = 0; i < this.bytes; ++i) {
            byte b = (byte)Util.getUIntFromByteArray(eeprom, offsetBit + i * 8, 8);
            s = s + Util.byteToHex(b);
        }
        DefaultCaret caret = (DefaultCaret)this.input.getCaret();
        caret.setUpdatePolicy(1);
        this.input.setText(s);
        caret.setUpdatePolicy(2);
        return this.bytes * 8;
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        String s = this.input.getText();
        for (int i = 0; i < this.bytes; ++i) {
            byte b = Util.hexToByte(Character.valueOf(s.charAt(i * 2)), Character.valueOf(s.charAt(i * 2 + 1)));
            Util.setUIntInByteArray(b, eeprom, offsetBit, 8);
            offsetBit += 8;
        }
        return this.bytes * 8;
    }

    @Override
    public String getValue(boolean humanReadable) {
        return this.input.getText();
    }
}

