/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.LabelArea;
import shcee.SHCEEMain;
import shcee.Util;
import shcee.editors.AbstractEditor;

public class EnumEditor
extends AbstractEditor {
    private static final long serialVersionUID = -7583780384335242111L;
    private int bits;
    private ArrayList<Integer> itemIndex2enumValue;
    private HashMap<Integer, Integer> enumValue2itemIndex;
    private JComboBox input;

    public EnumEditor(Node root) {
        super(root);
        LabelArea formatLabel = new LabelArea("Enum value of " + this.bits + " bits");
        this.add(formatLabel);
        this.add(this.input);
        String blockDescription = Util.getChildNodeValue(root, "Description");
        LabelArea descriptionLabel = new LabelArea(blockDescription);
        this.add(descriptionLabel);
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumEditor.this.onChangeValue();
            }
        });
    }

    protected void onChangeValue() {
        if (this.id.equals("DeviceType")) {
            SHCEEMain.mySHCEEMain.valueEditor.updateBlockVisibility();
        }
    }

    @Override
    public boolean dataIsValid() {
        return true;
    }

    @Override
    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int enumValue = Util.getUIntFromByteArray(eeprom, offsetBit, this.bits);
        int index = 0;
        if (this.enumValue2itemIndex.containsKey(enumValue)) {
            index = this.enumValue2itemIndex.get(enumValue);
        }
        this.input.setSelectedIndex(index);
        return this.bits;
    }

    @Override
    public void setDefinitionParameter(Node n) {
        String name;
        if (null == this.itemIndex2enumValue) {
            this.itemIndex2enumValue = new ArrayList();
            this.enumValue2itemIndex = new HashMap();
            this.input = new JComboBox();
        }
        if ((name = n.getNodeName()).equals("Bits")) {
            this.bits = Integer.parseInt(n.getFirstChild().getNodeValue());
        } else if (name.equals("Element")) {
            NodeList nl = n.getChildNodes();
            String v = "";
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n2 = nl.item(i);
                String name2 = n2.getNodeName();
                if (name2.equals("Value")) {
                    v = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (!name2.equals("Name")) continue;
                this.input.addItem(n2.getFirstChild().getNodeValue() + " (" + v + ")");
                this.itemIndex2enumValue.add(Integer.parseInt(v));
                this.enumValue2itemIndex.put(Integer.parseInt(v), this.input.getItemCount() - 1);
            }
        }
    }

    @Override
    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int value = this.itemIndex2enumValue.get(this.input.getSelectedIndex());
        Util.setUIntInByteArray(value, eeprom, offsetBit, this.bits);
        return this.bits;
    }

    @Override
    public String getValue(boolean humanReadable) {
        if (humanReadable) {
            return (String)this.input.getSelectedItem();
        }
        return "" + this.itemIndex2enumValue.get(this.input.getSelectedIndex());
    }

    public ArrayList<Integer> getValues() {
        return this.itemIndex2enumValue;
    }
}

