/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.SHCEEMain;
import shcee.SourceCodeGeneratorPacket;
import shcee.Util;

public class SourceCodeGeneratorE2P {
    private static String newline = System.getProperty("line.separator");

    public SourceCodeGeneratorE2P() throws TransformerException, IOException {
        Node xmlRoot;
        String errMsg = Util.conformsToSchema("e2p_layout.xml", "e2p_metamodel.xsd");
        if (null != errMsg) {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "e2p_layout.xml does not conform to e2p_metamodel.xsd.\nError message:\n" + errMsg, "Error", 0);
            return;
        }
        try {
            xmlRoot = Util.readXML(new File("e2p_layout.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "e2p_layout.xml could not be loaded", "Error", 0);
            return;
        }
        xmlRoot = Util.getChildNode(xmlRoot, "E2P");
        int offset = 0;
        offset += this.generateBlockHeaderFile(xmlRoot, "Hardware", offset);
        offset += this.generateBlockHeaderFile(xmlRoot, "Generic", offset);
        NodeList blocks = XPathAPI.selectNodeList(xmlRoot, "Block");
        for (int b = 0; b < blocks.getLength(); ++b) {
            Node block = blocks.item(b);
            String blockName = Util.getChildNodeValue(block, "Name");
            if (blockName.equals("Hardware") || blockName.equals("Generic")) continue;
            Node restrictionValueNode = XPathAPI.selectSingleNode(block, "Restriction[RefID='DeviceType']");
            String deviceTypeID = Util.getChildNodeValue(restrictionValueNode, "Value");
            String deviceTypeName = this.deviceTypeNameOfDeviceTypeID(xmlRoot, Integer.parseInt(deviceTypeID));
            this.generateBlockHeaderFile(xmlRoot, deviceTypeName, offset);
        }
    }

    private String deviceTypeNameOfDeviceTypeID(Node xmlRoot, int devTypeID) throws TransformerException {
        Node def = XPathAPI.selectSingleNode(xmlRoot, "Block/EnumValue[ID='DeviceType']/Element[Value=" + devTypeID + "]");
        return Util.getChildNodeValue(def, "Name");
    }

    private int generateBlockHeaderFile(Node xmlRoot, String blockName, int offset) throws IOException, TransformerException {
        PrintWriter out = new PrintWriter(new FileWriter("../../firmware/src_common/e2p_" + blockName.toLowerCase() + ".h"));
        out.println(SourceCodeGeneratorPacket.genCopyrightNotice());
        out.println("#ifndef _E2P_" + blockName.toUpperCase() + "_H");
        out.println("#define _E2P_" + blockName.toUpperCase() + "_H");
        out.println("");
        out.println("");
        Node hwConfigBlock = XPathAPI.selectSingleNode(xmlRoot, "Block[Name='" + blockName + "']");
        StringBuilder fieldDefs = new StringBuilder();
        int length = this.generateFieldDefs(hwConfigBlock, offset, fieldDefs);
        out.println("// ---------- " + blockName + " ----------");
        out.println("// Start offset (bit): " + offset);
        out.println("// Overall block length: " + length + " bits");
        out.println("");
        out.println(fieldDefs.toString());
        out.println("#endif /* _E2P_" + blockName.toUpperCase() + "_H */");
        out.close();
        return length;
    }

    private int generateFieldDefs(Node blockNode, int startOffset, StringBuilder sb) throws TransformerException {
        int offset = startOffset;
        NodeList elements = blockNode.getChildNodes();
        for (int e = 0; e < elements.getLength(); ++e) {
            String ID;
            Node element = elements.item(e);
            if (element.getNodeName().equals("EnumValue")) {
                String ID1 = Util.getChildNodeValue(element, "ID");
                sb.append("// EnumValue " + ID1 + newline);
                sb.append(newline);
                String ID2 = ID1.toUpperCase();
                NodeList enumElements = XPathAPI.selectNodeList(element, "Element");
                sb.append("typedef enum {" + newline);
                for (int ee = 0; ee < enumElements.getLength(); ++ee) {
                    Node enumElement = enumElements.item(ee);
                    String value = Util.getChildNodeValue(enumElement, "Value");
                    String name = ID2 + "_" + Util.getChildNodeValue(enumElement, "Name").toUpperCase().replace(' ', '_');
                    String suffix = ee == enumElements.getLength() - 1 ? "" : ",";
                    sb.append("  " + name + " = " + value + suffix + newline);
                }
                sb.append("} " + ID1 + "Enum;" + newline);
                sb.append(newline);
                sb.append("#define EEPROM_" + ID2 + "_BYTE " + offset / 8 + newline);
                sb.append("#define EEPROM_" + ID2 + "_BIT " + offset % 8 + newline);
                sb.append("#define EEPROM_" + ID2 + "_LENGTH_BITS 8" + newline);
                sb.append(newline);
                offset += 8;
                continue;
            }
            if (element.getNodeName().equals("UIntValue")) {
                ID = Util.getChildNodeValue(element, "ID");
                sb.append("// UIntValue " + ID + newline);
                sb.append(newline);
                ID = ID.toUpperCase();
                String bits = Util.getChildNodeValue(element, "Bits");
                String minVal = Util.getChildNodeValue(element, "MinVal");
                String maxVal = Util.getChildNodeValue(element, "MaxVal");
                sb.append("#define EEPROM_" + ID + "_BYTE " + offset / 8 + newline);
                sb.append("#define EEPROM_" + ID + "_BIT " + offset % 8 + newline);
                sb.append("#define EEPROM_" + ID + "_LENGTH_BITS " + bits + newline);
                sb.append("#define EEPROM_" + ID + "_MINVAL " + minVal + newline);
                sb.append("#define EEPROM_" + ID + "_MAXVAL " + maxVal + newline);
                sb.append(newline);
                offset += Integer.parseInt(bits);
                continue;
            }
            if (element.getNodeName().equals("ByteArray")) {
                ID = Util.getChildNodeValue(element, "ID");
                sb.append("// ByteArray " + ID + newline);
                sb.append(newline);
                ID = ID.toUpperCase();
                String bytes = Util.getChildNodeValue(element, "Bytes");
                sb.append("#define EEPROM_" + ID + "_BYTE " + offset / 8 + newline);
                sb.append("#define EEPROM_" + ID + "_BIT " + offset % 8 + newline);
                sb.append("#define EEPROM_" + ID + "_LENGTH_BYTES " + bytes + newline);
                sb.append(newline);
                offset += Integer.parseInt(bytes) * 8;
                continue;
            }
            if (!element.getNodeName().equals("Reserved")) continue;
            String bits = Util.getChildNodeValue(element, "Bits");
            sb.append("// Reserved area with " + bits + " bits" + newline);
            sb.append(newline);
            offset += Integer.parseInt(bits);
        }
        return offset - startOffset;
    }
}

