/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.LabelArea;
import shcee.Util;
import shcee.editors.AbstractEditor;
import shcee.editors.ByteArrayEditor;
import shcee.editors.EnumEditor;
import shcee.editors.ReservedBits;
import shcee.editors.UIntEditor;

public class Block
extends JPanel {
    private static final long serialVersionUID = -4893436425708148328L;
    private ArrayList<AbstractEditor> editors = new ArrayList();
    public String restrictionRefID = null;
    public String restrictionValue = null;
    private static Font titledBorderFont;

    public Block(Color bgColor, Node root) {
        this.setBackground(bgColor);
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        String blockName = Util.getChildNodeValue(root, "Name");
        TitledBorder border = BorderFactory.createTitledBorder(blockName);
        border.setTitleFont(Block.getTitledBorderFont());
        this.setBorder(border);
        String blockDescription = Util.getChildNodeValue(root, "Description");
        LabelArea descriptionLabel = new LabelArea(blockDescription);
        this.add(descriptionLabel);
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("Restriction")) {
                this.addRestriction(n);
                continue;
            }
            if (n.getNodeName().equals("UIntValue")) {
                this.addElem(new UIntEditor(n));
                continue;
            }
            if (n.getNodeName().equals("EnumValue")) {
                this.addElem(new EnumEditor(n));
                continue;
            }
            if (n.getNodeName().equals("ByteArray")) {
                this.addElem(new ByteArrayEditor(n));
                continue;
            }
            if (!n.getNodeName().equals("Reserved")) continue;
            this.addElem(new ReservedBits(n));
        }
    }

    public static Font getTitledBorderFont() {
        if (titledBorderFont == null) {
            titledBorderFont = UIManager.getDefaults().getFont("TitledBorder.font").deriveFont(1);
        }
        return titledBorderFont;
    }

    private void addRestriction(Node n) {
        this.restrictionRefID = Util.getChildNodeValue(n, "RefID");
        this.restrictionValue = Util.getChildNodeValue(n, "Value");
    }

    private void addElem(AbstractEditor c) {
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        c.setBackground(Util.blendColor(this.getBackground(), Color.white, 0.5));
        this.add(c);
        this.editors.add(c);
    }

    public int readFromEepromArray(byte[] eeprom, int offsetBit) {
        int myOffset = 0;
        for (AbstractEditor ed : this.editors) {
            int usedBits = ed.readFromEepromArray(eeprom, offsetBit + myOffset);
            myOffset += usedBits;
        }
        return myOffset;
    }

    public int writeToEepromArray(byte[] eeprom, int offsetBit) {
        int myOffset = 0;
        for (AbstractEditor ed : this.editors) {
            int usedBits = ed.writeToEepromArray(eeprom, offsetBit + myOffset);
            myOffset += usedBits;
        }
        return myOffset;
    }

    public String findValue(String id, boolean humanReadable) {
        for (AbstractEditor ed : this.editors) {
            if (!ed.id.equals(id)) continue;
            return ed.getValue(humanReadable);
        }
        return null;
    }

    public boolean dataIsValid() {
        for (AbstractEditor ed : this.editors) {
            if (ed.dataIsValid()) continue;
            return false;
        }
        return true;
    }
}

