/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.xml.transform.TransformerException;
import shcee.DeviceSelectorPanel;
import shcee.SourceCodeGeneratorE2P;
import shcee.SourceCodeGeneratorPacket;
import shcee.ValueEditorPanel;

public class SHCEEMain
extends JFrame {
    private static final long serialVersionUID = 1760274466931877539L;
    public static SHCEEMain mySHCEEMain;
    public static final String EEPROM_METAMODEL_XSD = "e2p_metamodel.xsd";
    public static final String EEPROM_LAYOUT_XML = "e2p_layout.xml";
    public static final String PACKET_METAMODEL_XSD = "packet_metamodel.xsd";
    public static final String PACKET_CATALOG_XML = "packet_layout.xml";
    public static int defaultWidth;
    public static int defaultHeight;
    private int oldWidth;
    public ValueEditorPanel valueEditor;
    public DeviceSelectorPanel deviceSelector;
    private JSplitPane jSplitPane;

    public SHCEEMain() {
        mySHCEEMain = this;
        this.initializeMainFrame();
        this.valueEditor = new ValueEditorPanel();
        this.deviceSelector = new DeviceSelectorPanel();
        this.jSplitPane = new JSplitPane(1);
        this.jSplitPane.add(this.deviceSelector);
        this.jSplitPane.add(this.valueEditor);
        this.add(this.jSplitPane);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SHCEEMain.this.onResize();
            }
        };
        this.addComponentListener(resizeListener);
        this.jSplitPane.setDividerLocation(defaultWidth * 45 / 100);
    }

    private void onResize() {
        this.jSplitPane.setDividerLocation((int)((long)this.jSplitPane.getDividerLocation() * (long)this.getWidth() / (long)this.oldWidth));
        this.oldWidth = this.getWidth();
    }

    private void initializeMainFrame() {
        this.setName("SHCEE");
        this.setDefaultCloseOperation(2);
        this.setTitle("smarthomatic EEPROM Editor");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(defaultWidth, defaultHeight);
        this.setLocation((screenSize.width - defaultWidth) / 2, (screenSize.height - defaultHeight) / 2);
        this.oldWidth = defaultWidth;
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("/gen")) {
            try {
                new SourceCodeGeneratorE2P();
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (args.length == 1 && args[0].equals("/packetgen")) {
            try {
                new SourceCodeGeneratorPacket();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            new SHCEEMain();
            mySHCEEMain.setVisible(true);
        }
    }

    public void loadE2pFile(String filename) {
        this.valueEditor.loadE2pFile(filename);
    }

    static {
        defaultWidth = 900;
        defaultHeight = 600;
    }
}

