/*
 * Decompiled with CFR 0.152.
 */
package shcee;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import shcee.SHCEEMain;
import shcee.Util;

public class SourceCodeGeneratorPacket {
    private static String newline = System.getProperty("line.separator");
    private Hashtable<String, Integer> headerExtOffset = new Hashtable();
    private Hashtable<String, Integer> headerExtFieldOccurrences = new Hashtable();

    public SourceCodeGeneratorPacket() throws Exception {
        Node xmlRoot;
        String errMsg = Util.conformsToSchema("packet_layout.xml", "packet_metamodel.xsd");
        if (null != errMsg) {
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "packet_layout.xml does not conform to packet_metamodel.xsd.\nError message:\n" + errMsg, "Error", 0);
            return;
        }
        try {
            xmlRoot = Util.readXML(new File("packet_layout.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(SHCEEMain.mySHCEEMain, "packet_layout.xml could not be loaded", "Error", 0);
            return;
        }
        xmlRoot = Util.getChildNode(xmlRoot, "Packet");
        int offsetHeader = this.generateHeaderFile(xmlRoot);
        Hashtable<Integer, String> messageTypes = this.getMessageTypes(xmlRoot);
        this.generateHeaderExtFiles(xmlRoot, offsetHeader, messageTypes);
        this.generateMessageGroupFiles(xmlRoot, messageTypes);
        this.generateHeaderExtensionCommonFile(xmlRoot, messageTypes);
    }

    private Hashtable<Integer, String> getMessageTypes(Node xmlRoot) throws TransformerException {
        Hashtable<Integer, String> h = new Hashtable<Integer, String>();
        NodeList msgTypeNodes = XPathAPI.selectNodeList(xmlRoot, "/Packet/Header/EnumValue[ID=\"MessageType\"]/Element");
        for (int d = 0; d < msgTypeNodes.getLength(); ++d) {
            Node msgTypeNode = msgTypeNodes.item(d);
            h.put(Integer.parseInt(Util.getChildNodeValue(msgTypeNode, "Value")), Util.getChildNodeValue(msgTypeNode, "Name"));
        }
        return h;
    }

    private int generateHeaderFile(Node xmlRoot) throws IOException, TransformerException {
        Node headerNode = Util.getChildNode(xmlRoot, "Header");
        PrintWriter outHeader = new PrintWriter(new FileWriter("../../firmware/src_common/packet_header.h"));
        outHeader.println(this.genCopyrightNotice());
        outHeader.println("#ifndef _PACKET_HEADER_H");
        outHeader.println("#define _PACKET_HEADER_H");
        outHeader.println("");
        outHeader.println("#include <stdbool.h>");
        outHeader.println("#include \"util.h\"");
        outHeader.println("#include \"e2p_access.h\"");
        outHeader.println("");
        outHeader.println("// Header size in bits (incl. header extension), set depending on used");
        outHeader.println("// MessageType and used for calculating message data offsets.");
        outHeader.println("uint8_t __HEADEROFFSETBITS;");
        outHeader.println("");
        outHeader.println("// Packet size in bytes including padding, set depending on MessageType,");
        outHeader.println("// MessageGroupID and MessageID and used for CRC32 calculation.");
        outHeader.println("uint8_t __PACKETSIZEBYTES;");
        outHeader.println("");
        outHeader.println("// Remember the MessageType after receiving a packet to reduce code size");
        outHeader.println("// in common header extension access functions.");
        outHeader.println("uint8_t __MESSAGETYPE;");
        outHeader.println("");
        NodeList messageGroupNodes = XPathAPI.selectNodeList(xmlRoot, "/Packet/MessageGroup");
        outHeader.println("// ENUM MessageGroupID");
        outHeader.println("typedef enum {");
        for (int d = 0; d < messageGroupNodes.getLength(); ++d) {
            Node msgGroupNode = messageGroupNodes.item(d);
            int messageGroupID = Integer.parseInt(Util.getChildNodeValue(msgGroupNode, "MessageGroupID"));
            String name = Util.getChildNodeValue(msgGroupNode, "Name").toUpperCase();
            String suffix = d == messageGroupNodes.getLength() - 1 ? "" : ",";
            outHeader.println("  MESSAGEGROUP_" + name + " = " + messageGroupID + suffix);
        }
        outHeader.println("} MessageGroupIDEnum;");
        outHeader.println("");
        StringBuilder funcDefsH = new StringBuilder();
        ArrayList<String> dataFieldsH = new ArrayList<String>();
        int offsetHeader = this.generateDataFieldDefs(headerNode, false, 0, "pkg_header", funcDefsH, dataFieldsH);
        outHeader.println(funcDefsH.toString());
        outHeader.println("// overall length: " + offsetHeader + " bits");
        outHeader.println("");
        outHeader.println("// Function to set CRC value after all data fields are set.");
        outHeader.println("static inline void pkg_header_calc_crc32(void)");
        outHeader.println("{");
        outHeader.println("  pkg_header_set_crc32(crc32(bufx + 4, __PACKETSIZEBYTES - 4));");
        outHeader.println("}");
        outHeader.println("");
        outHeader.println("// Function to check CRC value against calculated one (after reception).");
        outHeader.println("static inline bool pkg_header_check_crc32(uint8_t packet_size_bytes)");
        outHeader.println("{");
        outHeader.println("  return getBuf32(0) == crc32(bufx + 4, packet_size_bytes - 4);");
        outHeader.println("}");
        outHeader.println("");
        outHeader.println("#endif /* _PACKET_HEADER_H */");
        outHeader.close();
        return offsetHeader;
    }

    private void generateHeaderExtensionCommonFile(Node xmlRoot, Hashtable<Integer, String> messageTypes) throws Exception {
        PrintWriter outHeader = new PrintWriter(new FileWriter("../../firmware/src_common/packet_headerext_common.h"));
        outHeader.println(this.genCopyrightNotice());
        outHeader.println("#ifndef _PACKET_HEADEREXT_COMMON_H");
        outHeader.println("#define _PACKET_HEADEREXT_COMMON_H");
        outHeader.println("");
        outHeader.println("#include <stdbool.h>");
        outHeader.println("#include \"util.h\"");
        outHeader.println("#include \"e2p_access.h\"");
        outHeader.println("");
        for (Integer i : messageTypes.keySet()) {
            outHeader.println("#include \"packet_headerext_" + messageTypes.get(i).toLowerCase() + ".h\"");
        }
        outHeader.println("");
        outHeader.println("// This file contains functions to access fields common to several message");
        outHeader.println("// types. It allows the user to access the fields without explicitly");
        outHeader.println("// specifying the message type in the function call.");
        outHeader.println("// WARNING: If you access a field not contained in the received MessageType,");
        outHeader.println("// you get a wrong value 0!");
        outHeader.println("");
        outHeader.println("// Initialize the header offset variable, used to correctly interpret");
        outHeader.println("// contents of the header extension and the message data after reception.");
        outHeader.println("static void pkg_header_adjust_offset(void)");
        outHeader.println("{");
        outHeader.println("  __MESSAGETYPE = pkg_header_get_messagetype();");
        outHeader.println("");
        outHeader.println("  switch (__MESSAGETYPE)");
        outHeader.println("  {");
        for (Integer messageTypeID : messageTypes.keySet()) {
            String messageTypeName = messageTypes.get(messageTypeID);
            outHeader.println("    case MESSAGETYPE_" + messageTypeName.toUpperCase() + ":");
            outHeader.println("      __HEADEROFFSETBITS = " + this.headerExtOffset.get(messageTypeName) + ";");
            outHeader.println("      break;");
        }
        outHeader.println("  }");
        outHeader.println("}");
        outHeader.println("");
        for (String name : this.headerExtFieldOccurrences.keySet()) {
            String messageTypeName;
            String shcType = this.headerExtensionFieldType(xmlRoot, name);
            String cType = this.fieldTypeToCType(shcType);
            outHeader.println("// Set " + name + " (" + shcType + ")");
            outHeader.println("// Same function for all MessageTypes!");
            outHeader.println("static void pkg_headerext_common_set_" + name.toLowerCase() + "(" + cType + " val) __attribute__ ((unused));");
            outHeader.println("static void pkg_headerext_common_set_" + name.toLowerCase() + "(" + cType + " val)");
            outHeader.println("{");
            outHeader.println("  switch (__MESSAGETYPE)");
            outHeader.println("  {");
            for (Integer messageTypeID : messageTypes.keySet()) {
                messageTypeName = messageTypes.get(messageTypeID);
                if (!this.headerExtensionContainsField(xmlRoot, messageTypeID, name)) continue;
                outHeader.println("    case MESSAGETYPE_" + messageTypeName.toUpperCase() + ":");
                outHeader.println("      pkg_headerext_" + messageTypeName.toLowerCase() + "_set_" + name.toLowerCase() + "(val);");
                outHeader.println("      break;");
            }
            outHeader.println("    default:");
            outHeader.println("      break;");
            outHeader.println("  }");
            outHeader.println("}");
            outHeader.println("");
            outHeader.println("// Get " + name + " (" + shcType + ")");
            outHeader.println("// Same function for all MessageTypes!");
            outHeader.println("static " + cType + " pkg_headerext_common_get_" + name.toLowerCase() + "(void) __attribute__ ((unused));");
            outHeader.println("static " + cType + " pkg_headerext_common_get_" + name.toLowerCase() + "(void)");
            outHeader.println("{");
            outHeader.println("  switch (__MESSAGETYPE)");
            outHeader.println("  {");
            for (Integer messageTypeID : messageTypes.keySet()) {
                messageTypeName = messageTypes.get(messageTypeID);
                if (!this.headerExtensionContainsField(xmlRoot, messageTypeID, name)) continue;
                outHeader.println("    case MESSAGETYPE_" + messageTypeName.toUpperCase() + ":");
                outHeader.println("      return pkg_headerext_" + messageTypeName.toLowerCase() + "_get_" + name.toLowerCase() + "();");
                outHeader.println("      break;");
            }
            outHeader.println("    default:");
            outHeader.println("      return 0;");
            outHeader.println("      break;");
            outHeader.println("  }");
            outHeader.println("}");
            outHeader.println("");
        }
        outHeader.println("#endif /* _PACKET_HEADEREXT_COMMON_H */");
        outHeader.close();
    }

    private void generateHeaderExtFiles(Node xmlRoot, int offsetHeader, Hashtable<Integer, String> messageTypes) throws TransformerException, IOException {
        NodeList extensionNodes = XPathAPI.selectNodeList(xmlRoot, "HeaderExtension");
        for (int d = 0; d < extensionNodes.getLength(); ++d) {
            int offset = offsetHeader;
            Node extensionNode = extensionNodes.item(d);
            ArrayList<Integer> possibleMessageTypes = this.getPossibleMessageTypes(extensionNode);
            for (int p = 0; p < possibleMessageTypes.size(); ++p) {
                int messageTypeID = possibleMessageTypes.get(p);
                String messageTypeName = messageTypes.get(messageTypeID);
                String defineStr = "_PACKET_HEADEREXT_" + messageTypeName.toUpperCase() + "_H";
                boolean containsMessageData = Util.getChildNodeValue(extensionNode, "ContainsMessageData").equals("true");
                PrintWriter out = new PrintWriter(new FileWriter("../../firmware/src_common/packet_headerext_" + messageTypeName.toLowerCase() + ".h"));
                out.println(this.genCopyrightNotice());
                out.println("#ifndef " + defineStr);
                out.println("#define " + defineStr);
                out.println("");
                out.println("#include \"packet_header.h\"");
                out.println("");
                StringBuilder funcDefsHE = new StringBuilder();
                ArrayList<String> dataFieldsHE = new ArrayList<String>();
                int offsetHeaderExt = this.generateDataFieldDefs(extensionNode, false, offset, "pkg_headerext_" + messageTypeName.toLowerCase(), funcDefsHE, dataFieldsHE);
                out.println(funcDefsHE.toString());
                out.println("// overall length: " + offsetHeaderExt + " bits");
                out.println("// message data follows: " + (containsMessageData ? "yes" : "no"));
                out.println("");
                out.println("#endif /* " + defineStr + " */");
                this.headerExtOffset.put(messageTypeName, offsetHeaderExt);
                for (String name : dataFieldsHE) {
                    if (this.headerExtFieldOccurrences.containsKey(name)) {
                        this.headerExtFieldOccurrences.put(name, this.headerExtFieldOccurrences.get(name) + 1);
                        continue;
                    }
                    this.headerExtFieldOccurrences.put(name, 1);
                }
                out.close();
            }
        }
    }

    private void generateMessageGroupFiles(Node xmlRoot, Hashtable<Integer, String> messageTypes) throws TransformerException, IOException {
        NodeList msgGroupNodes = XPathAPI.selectNodeList(xmlRoot, "MessageGroup");
        for (int d = 0; d < msgGroupNodes.getLength(); ++d) {
            Node msgGroupNode = msgGroupNodes.item(d);
            Hashtable<Integer, String> messageIDs = new Hashtable<Integer, String>();
            String messageGroupName = Util.getChildNodeValue(msgGroupNode, "Name").toLowerCase().replace(' ', '_');
            String messageGroupID = Util.getChildNodeValue(msgGroupNode, "MessageGroupID");
            String description = Util.getChildNodeValue(msgGroupNode, "Description");
            PrintWriter out = new PrintWriter(new FileWriter("../../firmware/src_common/msggrp_" + messageGroupName + ".h"));
            out.println(this.genCopyrightNotice());
            out.println("#include \"packet_header.h\"");
            out.println("#include \"packet_headerext_common.h\"");
            for (Integer i : messageTypes.keySet()) {
                out.println("#include \"packet_headerext_" + messageTypes.get(i).toLowerCase() + ".h\"");
            }
            out.println("#include \"e2p_access.h\"");
            out.println("");
            String h = "// Message Group \"" + messageGroupName + "\"";
            out.println(h);
            out.println("// " + String.format("%-" + (h.length() - 3) + "s", "").replace(' ', '='));
            out.println("// MessageGroupID: " + messageGroupID);
            if (!description.equals("")) {
                out.println("// Description: " + description);
            }
            out.println("");
            NodeList messageNodes = XPathAPI.selectNodeList(msgGroupNode, "Message");
            out.println("// ENUM for MessageIDs of this MessageGroup");
            out.println("typedef enum {");
            for (int n = 0; n < messageNodes.getLength(); ++n) {
                Node messageNode = messageNodes.item(n);
                int messageID = Integer.parseInt(Util.getChildNodeValue(messageNode, "MessageID"));
                String name = Util.getChildNodeValue(messageNode, "Name").toUpperCase();
                String suffix = n == messageNodes.getLength() - 1 ? "" : ",";
                out.println("  MESSAGEID_" + messageGroupName.toUpperCase() + "_" + name + " = " + messageID + suffix);
            }
            out.println("} " + messageGroupName.toUpperCase() + "_MessageIDEnum;");
            out.println("");
            NodeList msg = XPathAPI.selectNodeList(msgGroupNode, "Message");
            for (int b = 0; b < msg.getLength(); ++b) {
                Node msgNode = msg.item(b);
                ArrayList<String> dataFields = new ArrayList<String>();
                ArrayList<Integer> possibleMessageTypes = this.getPossibleMessageTypes(msgNode);
                String messageName = Util.getChildNodeValue(msgNode, "Name").toLowerCase().replace(' ', '_');
                String messageID = Util.getChildNodeValue(msgNode, "MessageID").toLowerCase().replace(' ', '_');
                String validity = Util.getChildNodeValue(msgNode, "Validity");
                String msgDescription = Util.getChildNodeValue(msgNode, "Description");
                messageIDs.put(Integer.parseInt(messageID), messageName);
                String fullMessageName = messageGroupName + "_" + messageName;
                StringBuilder funcDefs = new StringBuilder();
                int offset2 = this.generateDataFieldDefs(msgNode, true, 0, "msg_" + fullMessageName, funcDefs, dataFields);
                out.println("");
                String h2 = "// Message \"" + fullMessageName + "\"";
                out.println(h2);
                out.println("// " + String.format("%-" + (h2.length() - 3) + "s", "").replace(' ', '-'));
                out.println("// MessageGroupID: " + messageGroupID);
                out.println("// MessageID: " + messageID);
                out.println("// Possible MessageTypes: " + this.createMessageTypeList(messageTypes, possibleMessageTypes));
                out.println("// Validity: " + validity);
                out.println("// Length w/o Header + HeaderExtension: " + offset2 + " bits");
                out.println("// Data fields: " + Util.arrayListToString(dataFields, ", "));
                out.println("// Description: " + msgDescription);
                out.println("");
                for (int p = 0; p < possibleMessageTypes.size(); ++p) {
                    int messageTypeID = possibleMessageTypes.get(p);
                    String messageTypeName = messageTypes.get(messageTypeID);
                    out.println("// Function to initialize header for the MessageType \"" + messageTypeName + "\".");
                    out.println("static inline void pkg_header_init_" + fullMessageName + "_" + messageTypeName.toLowerCase() + "(void)");
                    out.println("{");
                    out.println("  memset(&bufx[0], 0, sizeof(bufx));");
                    out.println("  pkg_header_set_messagetype(" + messageTypeID + ");");
                    if (this.headerExtensionContainsField(xmlRoot, messageTypeID, "MessageID")) {
                        out.println("  pkg_headerext_" + messageTypeName.toLowerCase() + "_set_messagegroupid(" + messageGroupID + ");");
                        out.println("  pkg_headerext_" + messageTypeName.toLowerCase() + "_set_messageid(" + messageID + ");");
                    }
                    int hdrBits = this.headerExtOffset.get(messageTypeName);
                    int ovrBits = hdrBits + offset2;
                    int neededBytes = (ovrBits - 1) / 8 + 1;
                    int packetBytes = ((neededBytes - 1) / 16 + 1) * 16;
                    out.println("  __HEADEROFFSETBITS = " + hdrBits + ";");
                    out.println("  __PACKETSIZEBYTES = " + packetBytes + ";");
                    out.println("}");
                    out.println("");
                }
                out.print(funcDefs.toString());
            }
            out.close();
        }
    }

    private String createMessageTypeList(Hashtable<Integer, String> messageTypes, ArrayList<Integer> possibleMessageTypes) {
        String res = "";
        for (int i = 0; i < possibleMessageTypes.size(); ++i) {
            if (i > 0) {
                res = res + ", ";
            }
            res = res + messageTypes.get(possibleMessageTypes.get(i));
        }
        return res;
    }

    private ArrayList<Integer> getPossibleMessageTypes(Node msgNode) throws TransformerException {
        ArrayList<Integer> res = new ArrayList<Integer>();
        NodeList possibleMessageTypeNodes = XPathAPI.selectNodeList(msgNode, "MessageType");
        for (int j = 0; j < possibleMessageTypeNodes.getLength(); ++j) {
            res.add(Integer.parseInt(possibleMessageTypeNodes.item(j).getFirstChild().getNodeValue()));
        }
        return res;
    }

    private boolean headerExtensionContainsField(Node xmlRoot, int messageTypeID, String fieldName) throws TransformerException {
        Node field = XPathAPI.selectSingleNode(xmlRoot, "HeaderExtension[MessageType=" + messageTypeID + "]/*[ID=\"" + fieldName + "\"]");
        return field != null;
    }

    private String fieldTypeToCType(String shcType) throws Exception {
        if (shcType.equals("UIntValue")) {
            return "uint32_t";
        }
        if (shcType.equals("BoolValue")) {
            return "bool";
        }
        throw new Exception("Unsupported common header extension field encountered.");
    }

    private String headerExtensionFieldType(Node xmlRoot, String name) throws TransformerException {
        Node field = XPathAPI.selectSingleNode(xmlRoot, "HeaderExtension/*[ID=\"" + name + "\"]");
        return field.getNodeName();
    }

    private int generateDataFieldDefs(Node dataNode, boolean useHeaderOffset, int offset, String functionPrefix, StringBuilder sb, ArrayList<String> dataFields) throws TransformerException {
        NodeList childs = dataNode.getChildNodes();
        for (int e = 0; e < childs.getLength(); ++e) {
            String offsetStr;
            String maxVal;
            String minVal;
            String ID;
            Node element = childs.item(e);
            if (element.getNodeName().equals("EnumValue")) {
                String ID1 = Util.getChildNodeValue(element, "ID");
                dataFields.add(ID1);
                int bits = Integer.parseInt(Util.getChildNodeValue(element, "Bits"));
                NodeList enumElements = XPathAPI.selectNodeList(element, "Element");
                sb.append("// ENUM " + ID1 + newline);
                sb.append("typedef enum {" + newline);
                for (int ee = 0; ee < enumElements.getLength(); ++ee) {
                    Node enumElement = enumElements.item(ee);
                    String value = Util.getChildNodeValue(enumElement, "Value");
                    String name = ID1.toUpperCase() + "_" + Util.getChildNodeValue(enumElement, "Name").toUpperCase().replace(' ', '_');
                    String suffix = ee == enumElements.getLength() - 1 ? "" : ",";
                    sb.append("  " + name + " = " + value + suffix + newline);
                }
                sb.append("} " + ID1 + "Enum;" + newline + newline);
                sb.append("// Set " + ID1 + " (EnumValue)" + newline);
                String offsetStr2 = this.generateOffsetString(useHeaderOffset, offset);
                sb.append("// Offset: " + offsetStr2 + ", length bits " + bits + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID1.toLowerCase() + "(" + ID1 + "Enum val)" + newline);
                sb.append("{" + newline);
                sb.append("  array_write_UIntValue(" + offsetStr2 + ", " + bits + ", val, bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                sb.append("// Get " + ID1 + " (EnumValue)" + newline);
                sb.append("// Offset: " + offsetStr2 + ", length bits " + bits + newline);
                sb.append("static inline " + ID1 + "Enum " + functionPrefix + "_get_" + ID1.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return array_read_UIntValue32(" + offsetStr2 + ", " + bits + ", 0, " + ((1 << bits) - 1) + ", bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += bits;
                continue;
            }
            if (element.getNodeName().equals("UIntValue")) {
                ID = Util.getChildNodeValue(element, "ID");
                dataFields.add(ID);
                String bits = Util.getChildNodeValue(element, "Bits");
                minVal = Util.getChildNodeValue(element, "MinVal");
                maxVal = Util.getChildNodeValue(element, "MaxVal");
                sb.append("// Set " + ID + " (UIntValue)" + newline);
                offsetStr = this.generateOffsetString(useHeaderOffset, offset);
                sb.append("// Offset: " + offsetStr + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(uint32_t val)" + newline);
                sb.append("{" + newline);
                sb.append("  array_write_UIntValue(" + offsetStr + ", " + bits + ", val, bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                sb.append("// Get " + ID + " (UIntValue)" + newline);
                sb.append("// Offset: " + offsetStr + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline uint32_t " + functionPrefix + "_get_" + ID.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return array_read_UIntValue32(" + offsetStr + ", " + bits + ", " + minVal + ", " + maxVal + ", bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += Integer.parseInt(bits);
                continue;
            }
            if (element.getNodeName().equals("IntValue")) {
                ID = Util.getChildNodeValue(element, "ID");
                dataFields.add(ID);
                String bits = Util.getChildNodeValue(element, "Bits");
                minVal = Util.getChildNodeValue(element, "MinVal");
                maxVal = Util.getChildNodeValue(element, "MaxVal");
                sb.append("// Set " + ID + " (IntValue)" + newline);
                offsetStr = this.generateOffsetString(useHeaderOffset, offset);
                sb.append("// Offset: " + offsetStr + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(int32_t val)" + newline);
                sb.append("{" + newline);
                sb.append("  array_write_IntValue(" + offsetStr + ", " + bits + ", val, bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                sb.append("// Get " + ID + " (IntValue)" + newline);
                sb.append("// Offset: " + offsetStr + ", length bits " + bits + ", min val " + minVal + ", max val " + maxVal + newline);
                sb.append("static inline int32_t " + functionPrefix + "_get_" + ID.toLowerCase() + "(void)" + newline);
                sb.append("{" + newline);
                sb.append("  return array_read_IntValue32(" + offsetStr + ", " + bits + ", " + minVal + ", " + maxVal + ", bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += Integer.parseInt(bits);
                continue;
            }
            if (element.getNodeName().equals("ByteArray")) {
                ID = Util.getChildNodeValue(element, "ID");
                String bytes = Util.getChildNodeValue(element, "Bytes");
                dataFields.add(ID);
                sb.append("// Set " + ID + " (ByteArray)" + newline);
                String offsetStr3 = this.generateOffsetString(useHeaderOffset, offset);
                sb.append("// Offset: " + offsetStr3 + ", length bytes " + bytes + newline);
                sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(array * val)" + newline);
                sb.append("{" + newline);
                sb.append("  array_write_ByteArray(" + offsetStr3 + ", " + bytes + ", val, bufx);" + newline);
                sb.append("}" + newline);
                sb.append(newline);
                offset += Integer.parseInt(bytes) * 8;
                continue;
            }
            if (element.getNodeName().equals("Reserved")) {
                String bits = Util.getChildNodeValue(element, "Bits");
                sb.append("// Reserved area with " + bits + " bits" + newline);
                sb.append(newline);
                offset += Integer.parseInt(bits);
                continue;
            }
            if (!element.getNodeName().equals("BoolValue")) continue;
            ID = Util.getChildNodeValue(element, "ID");
            dataFields.add(ID);
            sb.append("// Set " + ID + " (BoolValue)" + newline);
            String offsetStr4 = this.generateOffsetString(useHeaderOffset, offset);
            sb.append("// Offset: " + offsetStr4 + ", length bits 1" + newline);
            sb.append("static inline void " + functionPrefix + "_set_" + ID.toLowerCase() + "(bool val)" + newline);
            sb.append("{" + newline);
            sb.append("  array_write_UIntValue(" + offsetStr4 + ", " + 1 + ", val ? 1 : 0, bufx);" + newline);
            sb.append("}" + newline);
            sb.append(newline);
            sb.append("// Get " + ID + " (BoolValue)" + newline);
            sb.append("// Offset: " + offsetStr4 + ", length bits 1" + newline);
            sb.append("static inline bool " + functionPrefix + "_get_" + ID.toLowerCase() + "(void)" + newline);
            sb.append("{" + newline);
            sb.append("  return array_read_IntValue32(" + offsetStr4 + ", 1, 0, 1, bufx) == 1;" + newline);
            sb.append("}" + newline);
            sb.append(newline);
            ++offset;
        }
        return offset;
    }

    private String generateOffsetString(boolean useHeaderOffset, int offset) {
        if (useHeaderOffset) {
            return "((uint16_t)__HEADEROFFSETBITS + " + offset + ") / 8, ((uint16_t)__HEADEROFFSETBITS + " + offset + ") % 8";
        }
        return offset / 8 + ", " + offset % 8;
    }

    private String genCopyrightNotice() {
        return "/*" + newline + "* This file is part of smarthomatic, http://www.smarthomatic.org." + newline + "* Copyright (c) 2013 Uwe Freese" + newline + "*" + newline + "* smarthomatic is free software: you can redistribute it and/or modify it" + newline + "* under the terms of the GNU General Public License as published by the" + newline + "* Free Software Foundation, either version 3 of the License, or (at your" + newline + "* option) any later version." + newline + "*" + newline + "* smarthomatic is distributed in the hope that it will be useful, but" + newline + "* WITHOUT ANY WARRANTY; without even the implied warranty of" + newline + "* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General" + newline + "* Public License for more details." + newline + "*" + newline + "* You should have received a copy of the GNU General Public License along" + newline + "* with smarthomatic. If not, see <http://www.gnu.org/licenses/>." + newline + "*" + newline + "* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" + newline + "* ! WARNING: This file is generated by the SHC EEPROM editor and should !" + newline + "* ! never be modified manually.                                         !" + newline + "* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" + newline + "*/" + newline;
    }
}

