/*
 * Decompiled with CFR 0.152.
 */
package shcee.editors;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractEditor
extends JPanel {
    private static final long serialVersionUID = -1309313960513732321L;
    public String id;

    public AbstractEditor(Node root) {
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String name = n.getNodeName();
            if (name.equals("ID")) {
                this.id = n.getFirstChild().getNodeValue();
                continue;
            }
            this.setDefinitionParameter(n);
        }
        if (null == this.id) {
            this.id = "Reserved";
        }
        TitledBorder border = BorderFactory.createTitledBorder(this.id);
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        this.setBorder(border);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractEditor.this.onResize();
            }
        };
        this.addComponentListener(resizeListener);
    }

    private void onResize() {
        this.invalidate();
    }

    public abstract void setDefinitionParameter(Node var1);

    public abstract int readFromEepromArray(byte[] var1, int var2);

    public abstract int writeToEepromArray(byte[] var1, int var2);

    public abstract boolean dataIsValid();

    public abstract String getValue(boolean var1);
}

